/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.TestUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

@SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key="org.apache.commons.exec.lenient", value="false"), @SetSystemProperty(key="org.apache.commons.exec.debug", value="true")})
public class LogOutputStreamTest {
    private final Executor exec = DefaultExecutor.builder().get();
    private final File testDir = new File("src/test/scripts");
    private OutputStream systemOut;
    private final Path environmentScript = TestUtil.resolveScriptPathForOS(this.testDir + "/environment");
    private final Path utf8CharacterScript = TestUtil.resolveScriptPathForOS(this.testDir + "/utf8Characters");

    @AfterEach
    public void tearDown() throws Exception {
        if (this.systemOut != null) {
            this.systemOut.close();
        }
    }

    @Test
    public void testStdout() throws Exception {
        this.systemOut = new SystemLogOutputStream(1);
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(this.systemOut, this.systemOut));
        CommandLine cl = new CommandLine(this.environmentScript);
        int exitValue = this.exec.execute(cl);
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
    }

    @Test
    @Disabled(value="The file utf8CharacterScript is missing from the repository and is not in its history")
    public void testStdoutWithUTF8Characters() throws Exception {
        this.systemOut = new SystemLogOutputStream(1, StandardCharsets.UTF_8);
        this.exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(this.systemOut, this.systemOut));
        CommandLine cl = new CommandLine(this.utf8CharacterScript);
        int exitValue = this.exec.execute(cl);
        Assertions.assertFalse((boolean)this.exec.isFailure(exitValue));
        Assertions.assertEquals((Object)"This string contains UTF-8 characters like the see no evil monkey \ud83d\ude48 and the right single quotation mark \u2019", (Object)((SystemLogOutputStream)((Object)this.systemOut)).getOutput());
    }

    private static final class SystemLogOutputStream
    extends LogOutputStream {
        StringBuffer output = new StringBuffer();

        private SystemLogOutputStream(int level) {
            super(level);
        }

        private SystemLogOutputStream(int level, Charset charset) {
            super(level, charset);
        }

        private String getOutput() {
            return this.output.toString();
        }

        protected void processLine(String line, int level) {
            System.out.println(line);
            this.output.append(line);
        }
    }
}

