/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.issues;

import java.io.File;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.exec.AbstractExecTest;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class Exec65Test
extends AbstractExecTest {
    @Test
    @EnabledOnOs(value={OS.MAC})
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    public void testExec65WithSleepUsingShellScript() throws Exception {
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err));
        executor.setWatchdog(new ExecuteWatchdog(3000L));
        CommandLine command = new CommandLine(this.resolveTestScript("sleep"));
        Assertions.assertThrows(ExecuteException.class, () -> executor.execute(command));
    }

    @Test
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    public void testExec65WithSleepUsingShellScriptAndJDKOnly() throws Exception {
        Process process = Runtime.getRuntime().exec(this.resolveTestScript("sleep").getAbsolutePath());
        Thread.sleep(3000L);
        process.destroy();
        process.waitFor();
        Assertions.assertTrue((process.exitValue() != 0 ? 1 : 0) != 0);
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    public void testExec65WithSudoUsingShellScript() throws Exception {
        Assumptions.assumeFalse((boolean)new File(".").getAbsolutePath().contains("travis"), (String)"Test is skipped on travis, because we have to be a sudoer to make the other tests pass.");
        Assumptions.assumeTrue((System.getenv("GITHUB_WORKFLOW") == null ? 1 : 0) != 0);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in));
        executor.setWatchdog(new ExecuteWatchdog(3000L));
        CommandLine command = new CommandLine(this.resolveTestScript("issues", "exec-65"));
        Assertions.assertThrows(ExecuteException.class, () -> executor.execute(command));
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    @Timeout(value=15000L, unit=TimeUnit.MILLISECONDS)
    public void testExec65WitSleepUsingSleepCommandDirectly() throws Exception {
        ExecuteWatchdog watchdog = new ExecuteWatchdog(3000L);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        CommandLine command = new CommandLine("sleep");
        command.addArgument("60");
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err));
        executor.setWatchdog(watchdog);
        Assertions.assertThrows(ExecuteException.class, () -> executor.execute(command));
    }
}

