/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.util.ReflectionUtils;

class MethodInvocation<T>
implements InvocationInterceptor.Invocation<T>,
ReflectiveInvocationContext<Method> {
    private final Method method;
    private final Optional<Object> target;
    private final Object[] arguments;

    MethodInvocation(Method method, Optional<Object> target, Object[] arguments) {
        this.method = method;
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.target.map(Object::getClass).orElseGet(this.method::getDeclaringClass);
    }

    @Override
    public Optional<Object> getTarget() {
        return this.target;
    }

    @Override
    public Method getExecutable() {
        return this.method;
    }

    @Override
    public List<Object> getArguments() {
        return Collections.unmodifiableList(Arrays.asList(this.arguments));
    }

    @Override
    public T proceed() {
        return (T)ReflectionUtils.invokeMethod(this.method, this.target.orElse(null), this.arguments);
    }
}

