/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class Ia5StringSyntaxChecker
extends SyntaxChecker {
    public static final Ia5StringSyntaxChecker INSTANCE = new Ia5StringSyntaxChecker("1.3.6.1.4.1.1466.115.121.1.26");

    private Ia5StringSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{"null"}));
            }
            return true;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])((byte[])value)) : value.toString());
        boolean result = Strings.isIA5String((String)strValue);
        if (result) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_13701_SYNTAX_VALID, (Object[])new Object[]{value}));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.err((I18n)I18n.ERR_13210_SYNTAX_INVALID, (Object[])new Object[]{value}));
        }
        return result;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<Ia5StringSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.1466.115.121.1.26");
        }

        @Override
        public Ia5StringSyntaxChecker build() {
            return new Ia5StringSyntaxChecker(this.oid);
        }
    }
}

