/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v2.impl;

import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.utils.InsertTabletSortDataUtils;
import org.apache.iotdb.db.protocol.rest.v2.RestApiService;
import org.apache.iotdb.db.protocol.rest.v2.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.v2.handler.ExecuteStatementHandler;
import org.apache.iotdb.db.protocol.rest.v2.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.v2.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.v2.handler.StatementConstructionHandler;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertRecordsRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.v2.model.SQL;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.protocol.thrift.OperationType;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;

public class RestApiServiceImpl
extends RestApiService {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private final AuthorizationHandler authorizationHandler = new AuthorizationHandler();
    private final Integer defaultQueryRowLimit = IoTDBRestServiceDescriptor.getInstance().getConfig().getRestQueryDefaultRowSizeLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeNonQueryStatement(SQL sql, SecurityContext securityContext) {
        Response costTime4;
        boolean finish;
        long startTime;
        Statement statement;
        Long queryId;
        block21: {
            block20: {
                block19: {
                    queryId = null;
                    statement = null;
                    startTime = System.nanoTime();
                    finish = false;
                    RequestValidationHandler.validateSQL(sql);
                    statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
                    if (statement != null) break block19;
                    Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SQL_PARSE_ERROR.getStatusCode())).message("This operation type is not supported")).build();
                    long costTime2 = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.getType().name(), costTime2));
                    if (queryId != null) {
                        if (finish) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime2);
                        }
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response;
                }
                if (ExecuteStatementHandler.validateStatement(statement)) break block20;
                Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                long costTime3 = System.nanoTime() - startTime;
                Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.getType().name(), costTime2));
                if (queryId != null) {
                    if (finish) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime3);
                    }
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return response;
            }
            Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
            if (response == null) break block21;
            Response costTime3 = response;
            long costTime4 = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.getType().name(), costTime2));
            if (queryId != null) {
                if (finish) {
                    long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                    CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime4);
                }
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return costTime3;
        }
        try {
            queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.executeForTreeModel(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), sql.getSql(), this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold(), false);
            finish = true;
            costTime4 = this.responseGenerateHelper(result);
        }
        catch (Exception e) {
            Response response;
            try {
                finish = true;
                response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
            catch (Throwable throwable) {
                long costTime5 = System.nanoTime() - startTime;
                Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.getType().name(), costTime2));
                if (queryId != null) {
                    if (finish) {
                        long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                        CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime5);
                    }
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                throw throwable;
            }
            long costTime6 = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.getType().name(), costTime2));
            if (queryId != null) {
                if (finish) {
                    long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                    CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime6);
                }
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        long costTime7 = System.nanoTime() - startTime;
        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_NON_QUERY_PLAN, s.getType().name(), costTime2));
        if (queryId != null) {
            if (finish) {
                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime7);
            }
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return costTime4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Response executeQueryStatement(SQL sql, SecurityContext securityContext) {
        ExecutionResult result;
        boolean finish;
        long startTime;
        Statement statement;
        Long queryId;
        block30: {
            block29: {
                block28: {
                    block27: {
                        queryId = null;
                        statement = null;
                        startTime = System.nanoTime();
                        finish = false;
                        RequestValidationHandler.validateSQL(sql);
                        statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
                        if (statement != null) break block27;
                        Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SQL_PARSE_ERROR.getStatusCode())).message("This operation type is not supported")).build();
                        long costTime = System.nanoTime() - startTime;
                        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                        if (queryId != null) {
                            if (finish) {
                                long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                                CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime);
                            }
                            COORDINATOR.cleanupQueryExecution(queryId);
                        }
                        return response;
                    }
                    if (!ExecuteStatementHandler.validateStatement(statement)) break block28;
                    Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                    long costTime = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                    if (queryId != null) {
                        if (finish) {
                            long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                            CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime);
                        }
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response;
                }
                Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
                if (response == null) break block29;
                Response costTime = response;
                long costTime2 = System.nanoTime() - startTime;
                Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                if (queryId != null) {
                    if (finish) {
                        long executionTime3222 = COORDINATOR.getTotalExecutionTime(queryId);
                        CommonUtils.addQueryLatency(statement.getType(), executionTime3222 > 0L ? executionTime3222 : costTime2);
                    }
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return costTime;
            }
            queryId = SESSION_MANAGER.requestQueryId();
            result = COORDINATOR.executeForTreeModel(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), sql.getSql(), this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold(), true);
            finish = true;
            if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block30;
            Response costTime2 = Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
            long costTime = System.nanoTime() - startTime;
            Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
            if (queryId != null) {
                if (finish) {
                    long executionTime = COORDINATOR.getTotalExecutionTime(queryId);
                    CommonUtils.addQueryLatency(statement.getType(), executionTime > 0L ? executionTime : costTime);
                }
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return costTime2;
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        Response executionTime3222 = QueryDataSetHandler.fillQueryDataSet(queryExecution, statement, sql.getRowLimit() == null ? this.defaultQueryRowLimit : sql.getRowLimit());
        threadName.close();
        long costTime = System.nanoTime() - startTime;
        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
        if (queryId != null) {
            if (finish) {
                long executionTime2 = COORDINATOR.getTotalExecutionTime(queryId);
                CommonUtils.addQueryLatency(statement.getType(), executionTime2 > 0L ? executionTime2 : costTime);
            }
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return executionTime3222;
        {
            catch (Throwable executionTime3222) {
                try {
                    try {
                        try {
                            threadName.close();
                        }
                        catch (Throwable throwable) {
                            executionTime3222.addSuppressed(throwable);
                        }
                        throw executionTime3222;
                    }
                    catch (Exception e) {
                        finish = true;
                        Response response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                        long costTime3 = System.nanoTime() - startTime;
                        Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                        if (queryId != null) {
                            if (finish) {
                                long executionTime4 = COORDINATOR.getTotalExecutionTime(queryId);
                                CommonUtils.addQueryLatency(statement.getType(), executionTime4 > 0L ? executionTime4 : costTime3);
                            }
                            COORDINATOR.cleanupQueryExecution(queryId);
                        }
                        return response;
                    }
                }
                catch (Throwable throwable) {
                    long costTime4 = System.nanoTime() - startTime;
                    Optional.ofNullable(statement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.EXECUTE_QUERY_STATEMENT, s.getType().name(), costTime));
                    if (queryId != null) {
                        if (finish) {
                            long executionTime5 = COORDINATOR.getTotalExecutionTime(queryId);
                            CommonUtils.addQueryLatency(statement.getType(), executionTime5 > 0L ? executionTime5 : costTime4);
                        }
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response insertRecords(InsertRecordsRequest insertRecordsRequest, SecurityContext securityContext) {
        Response costTime2;
        InsertRowsStatement insertRowsStatement;
        long startTime;
        Long queryId;
        block9: {
            queryId = null;
            startTime = System.nanoTime();
            insertRowsStatement = null;
            RequestValidationHandler.validateInsertRecordsRequest(insertRecordsRequest);
            insertRowsStatement = StatementConstructionHandler.createInsertRowsStatement(insertRecordsRequest);
            Response response = this.authorizationHandler.checkAuthority(securityContext, insertRowsStatement);
            if (response == null) break block9;
            Response response2 = response;
            long costTime2 = System.nanoTime() - startTime;
            Optional.ofNullable(insertRowsStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_RECORDS, s.getType().name(), costTime2));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response2;
        }
        try {
            queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.executeForTreeModel(insertRowsStatement, SESSION_MANAGER.requestQueryId(), SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold(), false);
            costTime2 = this.responseGenerateHelper(result);
        }
        catch (Exception e) {
            Response response;
            try {
                response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
            catch (Throwable throwable) {
                long costTime3 = System.nanoTime() - startTime;
                Optional.ofNullable(insertRowsStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_RECORDS, s.getType().name(), costTime2));
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                throw throwable;
            }
            long costTime4 = System.nanoTime() - startTime;
            Optional.ofNullable(insertRowsStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_RECORDS, s.getType().name(), costTime2));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        long costTime5 = System.nanoTime() - startTime;
        Optional.ofNullable(insertRowsStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_RECORDS, s.getType().name(), costTime2));
        if (queryId != null) {
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return costTime2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response insertTablet(InsertTabletRequest insertTabletRequest, SecurityContext securityContext) {
        Response costTime2;
        InsertTabletStatement insertTabletStatement;
        long startTime;
        Long queryId;
        block10: {
            Response response;
            queryId = null;
            startTime = System.nanoTime();
            insertTabletStatement = null;
            RequestValidationHandler.validateInsertTabletRequest(insertTabletRequest);
            if (!InsertTabletSortDataUtils.checkSorted(insertTabletRequest.getTimestamps())) {
                int[] index = InsertTabletSortDataUtils.sortTimeStampList(insertTabletRequest.getTimestamps());
                insertTabletRequest.getTimestamps().sort(Long::compareTo);
                insertTabletRequest.setValues(InsertTabletSortDataUtils.sortList(insertTabletRequest.getValues(), index, insertTabletRequest.getDataTypes().size()));
            }
            if ((response = this.authorizationHandler.checkAuthority(securityContext, insertTabletStatement = StatementConstructionHandler.constructInsertTabletStatement(insertTabletRequest))) == null) break block10;
            Response response2 = response;
            long costTime2 = System.nanoTime() - startTime;
            Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime2));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response2;
        }
        try {
            queryId = SESSION_MANAGER.requestQueryId();
            ExecutionResult result = COORDINATOR.executeForTreeModel(insertTabletStatement, SESSION_MANAGER.requestQueryId(), SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold(), false);
            costTime2 = this.responseGenerateHelper(result);
        }
        catch (Exception e) {
            Response response;
            try {
                response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
            }
            catch (Throwable throwable) {
                long costTime3 = System.nanoTime() - startTime;
                Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime2));
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                throw throwable;
            }
            long costTime4 = System.nanoTime() - startTime;
            Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime2));
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        long costTime5 = System.nanoTime() - startTime;
        Optional.ofNullable(insertTabletStatement).ifPresent(s -> CommonUtils.addStatementExecutionLatency(OperationType.INSERT_TABLET, s.getType().name(), costTime2));
        if (queryId != null) {
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return costTime2;
    }

    private Response responseGenerateHelper(ExecutionResult result) {
        if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            return Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name())).build();
        }
        if (result.status.code == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            List subStatus = result.status.getSubStatus();
            StringBuilder errMsg = new StringBuilder();
            for (TSStatus status : subStatus) {
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
                errMsg.append(status.getMessage()).append("; ");
            }
            return Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.MULTIPLE_ERROR.getStatusCode())).message(errMsg.toString())).build();
        }
        return Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.v2.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
    }
}

