/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.schema;

import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedInsertStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaValidator.class);

    public static void validate(ISchemaFetcher schemaFetcher, InsertBaseStatement insertStatement, MPPQueryContext context) {
        try {
            if (insertStatement instanceof InsertRowsStatement || insertStatement instanceof InsertMultiTabletsStatement || insertStatement instanceof InsertRowsOfOneDeviceStatement) {
                schemaFetcher.fetchAndComputeSchemaWithAutoCreate(insertStatement.getSchemaValidationList(), context);
            } else {
                schemaFetcher.fetchAndComputeSchemaWithAutoCreate(insertStatement.getSchemaValidation(), context);
            }
            insertStatement.updateAfterSchemaValidation(context);
        }
        catch (QueryProcessException e) {
            throw new SemanticException(e.getMessage());
        }
    }

    public static void validate(Metadata metadata, WrappedInsertStatement insertStatement, MPPQueryContext context, AccessControl accessControl) {
        try {
            accessControl.checkCanInsertIntoTable(context.getSession().getUserName(), new QualifiedObjectName(PathUtils.unQualifyDatabaseName((String)insertStatement.getDatabase()), insertStatement.getTableName()));
            insertStatement.validateTableSchema(metadata, context);
            insertStatement.updateAfterSchemaValidation(context);
            insertStatement.validateDeviceSchema(metadata, context);
            insertStatement.removeAttributeColumns();
        }
        catch (QueryProcessException e) {
            throw new SemanticException(e.getMessage());
        }
    }

    public static ISchemaTree validate(ISchemaFetcher schemaFetcher, List<PartialPath> devicePaths, List<String[]> measurements, List<TSDataType[]> dataTypes, List<TSEncoding[]> encodings, List<CompressionType[]> compressionTypes, List<Boolean> isAlignedList, MPPQueryContext context) {
        return schemaFetcher.fetchSchemaListWithAutoCreate(devicePaths, measurements, dataTypes, encodings, compressionTypes, isAlignedList, context);
    }
}

