/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;

public class AliasedRelation
extends Relation {
    private final Relation relation;
    private final Identifier alias;
    private final List<Identifier> columnNames;

    public AliasedRelation(Relation relation, Identifier alias, List<Identifier> columnNames) {
        super(null);
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.alias = Objects.requireNonNull(alias, "alias is null");
        this.columnNames = columnNames;
    }

    public AliasedRelation(NodeLocation location, Relation relation, Identifier alias, List<Identifier> columnNames) {
        super(Objects.requireNonNull(location, "location is null"));
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.alias = Objects.requireNonNull(alias, "alias is null");
        this.columnNames = columnNames;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Identifier getAlias() {
        return this.alias;
    }

    public List<Identifier> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAliasedRelation(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.relation);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("alias", (Object)this.alias).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasedRelation that = (AliasedRelation)o;
        return Objects.equals(this.relation, that.relation) && Objects.equals(this.alias, that.alias) && Objects.equals(this.columnNames, that.columnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relation, this.alias, this.columnNames);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!AliasedRelation.sameClass(this, other)) {
            return false;
        }
        AliasedRelation otherRelation = (AliasedRelation)other;
        return this.alias.equals(otherRelation.alias) && Objects.equals(this.columnNames, otherRelation.columnNames);
    }
}

