/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.table;

import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.table.TableNotExistsException;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.table.InformationSchema;
import org.apache.iotdb.commons.schema.table.TableType;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.session.IClientSession;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class InformationSchemaUtils {
    public static void checkDBNameInWrite(String dbName) {
        if (dbName.equals("information_schema")) {
            throw new SemanticException(new IoTDBException("The database 'information_schema' can only be queried", TSStatusCode.SEMANTIC_ERROR.getStatusCode()));
        }
    }

    public static void buildDatabaseTsBlock(TsBlockBuilder builder, boolean details, boolean withTime) {
        if (withTime) {
            builder.getTimeColumnBuilder().writeLong(0L);
        }
        builder.getColumnBuilder(0).writeBinary(new Binary("information_schema", TSFileConfig.STRING_CHARSET));
        builder.getColumnBuilder(1).writeBinary(new Binary("INF", TSFileConfig.STRING_CHARSET));
        builder.getColumnBuilder(2).appendNull();
        builder.getColumnBuilder(3).appendNull();
        builder.getColumnBuilder(4).appendNull();
        if (details) {
            builder.getColumnBuilder(5).appendNull();
            builder.getColumnBuilder(6).appendNull();
        }
        builder.declarePosition();
    }

    public static TsTable mayGetTable(String database, String tableName) {
        return "information_schema".equals(database) ? (TsTable)InformationSchema.getSchemaTables().get(tableName) : null;
    }

    public static boolean mayUseDB(String database, IClientSession clientSession, SettableFuture<ConfigTaskResult> future) {
        if (!database.equals("information_schema")) {
            return false;
        }
        clientSession.setDatabaseName("information_schema");
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        return true;
    }

    public static boolean mayShowTable(String database, boolean isDetails, SettableFuture<ConfigTaskResult> future) {
        if (!database.equals("information_schema")) {
            return false;
        }
        List outputDataTypes = (isDetails ? ColumnHeaderConstant.showTablesDetailsColumnHeaders : ColumnHeaderConstant.showTablesColumnHeaders).stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (String schemaTable : InformationSchema.getSchemaTables().keySet().stream().sorted().collect(Collectors.toList())) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(schemaTable, TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary("INF", TSFileConfig.STRING_CHARSET));
            if (isDetails) {
                builder.getColumnBuilder(2).writeBinary(new Binary("USING", TSFileConfig.STRING_CHARSET));
                builder.getColumnBuilder(3).appendNull();
                builder.getColumnBuilder(4).writeBinary(new Binary(TableType.SYSTEM_VIEW.getName(), TSFileConfig.STRING_CHARSET));
            }
            builder.declarePosition();
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), isDetails ? DatasetHeaderFactory.getShowTablesDetailsHeader() : DatasetHeaderFactory.getShowTablesHeader()));
        return true;
    }

    public static boolean mayDescribeTable(String database, String tableName, boolean isDetails, Boolean isShowOrCreateView, SettableFuture<ConfigTaskResult> future) {
        if (!database.equals("information_schema")) {
            return false;
        }
        if (!InformationSchema.getSchemaTables().containsKey(tableName)) {
            TableNotExistsException exception = new TableNotExistsException("information_schema", tableName);
            future.setException((Throwable)new IoTDBException(exception.getMessage(), exception.getErrorCode()));
            return true;
        }
        if (Objects.nonNull(isShowOrCreateView)) {
            throw new SemanticException("The system view does not support show create.");
        }
        TsTable table = (TsTable)InformationSchema.getSchemaTables().get(tableName);
        List outputDataTypes = (isDetails ? ColumnHeaderConstant.describeTableDetailsColumnHeaders : ColumnHeaderConstant.describeTableColumnHeaders).stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (TsTableColumnSchema columnSchema : table.getColumnList()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(columnSchema.getColumnName(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeBinary(new Binary(columnSchema.getDataType().name(), TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(2).writeBinary(new Binary(columnSchema.getColumnCategory().name(), TSFileConfig.STRING_CHARSET));
            if (isDetails) {
                builder.getColumnBuilder(3).writeBinary(new Binary("USING", TSFileConfig.STRING_CHARSET));
                builder.getColumnBuilder(4).appendNull();
            }
            builder.declarePosition();
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), isDetails ? DatasetHeaderFactory.getDescribeTableDetailsHeader() : DatasetHeaderFactory.getDescribeTableHeader()));
        return true;
    }

    private InformationSchemaUtils() {
    }
}

