/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table.argument;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.udf.api.type.Type;

public class DescribedSchema {
    private final List<Field> fields;

    private DescribedSchema(List<Field> fields) {
        Objects.requireNonNull(fields, "fields is null");
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("DescribedSchema has no fields");
        }
        this.fields = fields;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Field> fields = new ArrayList<Field>();

        public Builder addField(String name, Type type) {
            this.fields.add(new Field(name, type));
            return this;
        }

        public Builder addField(Optional<String> name, Type type) {
            this.fields.add(new Field(name, type));
            return this;
        }

        public DescribedSchema build() {
            return new DescribedSchema(this.fields);
        }
    }

    public static class Field {
        private final Optional<String> name;
        private final Type type;

        public Field(String name, Type type) {
            this.name = Optional.ofNullable(name);
            this.type = type;
        }

        public Field(Optional<String> name, Type type) {
            this.name = name;
            this.type = type;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

