/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.unary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.tsfile.utils.RamUsageEstimator;

public class LogicNotExpression
extends UnaryExpression {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(LogicNotExpression.class);

    public LogicNotExpression(Expression expression) {
        super(expression);
    }

    public LogicNotExpression(ByteBuffer byteBuffer) {
        super(Expression.deserialize(byteBuffer));
    }

    @Override
    public String getExpressionStringInternal() {
        return this.expression instanceof FunctionExpression || this.expression instanceof LeafOperand ? "!" + this.expression.getExpressionString() : "!(" + this.expression.getExpressionString() + ")";
    }

    @Override
    public String getOutputSymbolInternal() {
        return this.expression instanceof FunctionExpression || this.expression instanceof ConstantOperand || this.expression instanceof TimeSeriesOperand ? "!" + this.expression.getOutputSymbol() : "!(" + this.expression.getOutputSymbol() + ")";
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.LOGIC_NOT;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLogicNotExpression(this, context);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.expression);
    }
}

