/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache;

import java.util.Objects;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class TableDeviceSchemaCacheMetrics
implements IMetricSet {
    private static final String SCHEMA_CACHE_TOTAL_USAGE = "schema_cache_total_usage";
    private static final String SCHEMA_CACHE_MEM_CAPACITY = "schema_cache_mem_capacity";
    private final TableDeviceSchemaCache tableDeviceSchemaCache;

    public TableDeviceSchemaCacheMetrics(TableDeviceSchemaCache dataNodeSchemaCache) {
        this.tableDeviceSchemaCache = dataNodeSchemaCache;
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.CACHE.toString(), MetricLevel.IMPORTANT, (Object)this.tableDeviceSchemaCache, TableDeviceSchemaCache::getHitCount, new String[]{Tag.NAME.toString(), "SchemaCache", Tag.TYPE.toString(), "hit"});
        metricService.createAutoGauge(Metric.CACHE.toString(), MetricLevel.IMPORTANT, (Object)this.tableDeviceSchemaCache, TableDeviceSchemaCache::getRequestCount, new String[]{Tag.NAME.toString(), "SchemaCache", Tag.TYPE.toString(), "all"});
        metricService.createAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, (Object)this.tableDeviceSchemaCache, TableDeviceSchemaCache::getMemoryUsage, new String[]{Tag.NAME.toString(), SCHEMA_CACHE_TOTAL_USAGE});
        metricService.createAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, (Object)this.tableDeviceSchemaCache, TableDeviceSchemaCache::capacity, new String[]{Tag.NAME.toString(), SCHEMA_CACHE_MEM_CAPACITY});
        metricService.createAutoGauge(Metric.CACHE_ENTRIES_NUM.toString(), MetricLevel.IMPORTANT, (Object)this.tableDeviceSchemaCache, TableDeviceSchemaCache::entriesCount, new String[0]);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CACHE.toString(), new String[]{Tag.NAME.toString(), "SchemaCache", Tag.TYPE.toString(), "hit"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CACHE.toString(), new String[]{Tag.NAME.toString(), "SchemaCache", Tag.TYPE.toString(), "all"});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), SCHEMA_CACHE_TOTAL_USAGE});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), SCHEMA_CACHE_MEM_CAPACITY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.CACHE_ENTRIES_NUM.toString(), new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDeviceSchemaCacheMetrics that = (TableDeviceSchemaCacheMetrics)o;
        return Objects.equals(this.tableDeviceSchemaCache, that.tableDeviceSchemaCache);
    }

    public int hashCode() {
        return Objects.hash(this.tableDeviceSchemaCache);
    }
}

