/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Match;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.PatternVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Property;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.PropertyPattern;

public class WithPattern<T>
extends Pattern<T> {
    private final PropertyPattern<? super T, ?, ?> propertyPattern;

    public WithPattern(PropertyPattern<? super T, ?, ?> propertyPattern, Pattern<T> previous) {
        super(previous);
        this.propertyPattern = Objects.requireNonNull(propertyPattern, "propertyPattern is null");
    }

    public Pattern<?> getPattern() {
        return this.propertyPattern.getPattern();
    }

    public Property<? super T, ?, ?> getProperty() {
        return this.propertyPattern.getProperty();
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        BiFunction<Object, ?, Optional<?>> property = this.propertyPattern.getProperty().getFunction();
        Optional<?> propertyValue = property.apply(object, context);
        return propertyValue.map(value -> this.propertyPattern.getPattern().match(value, captures, context)).orElseGet(() -> Stream.of(new Match[0]));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitWith(this);
    }
}

