/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.intermediate;

import java.io.IOException;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.db.queryengine.transformation.api.YieldableState;
import org.apache.iotdb.db.queryengine.transformation.dag.adapter.ElasticSerializableTVListBackedSingleColumnWindow;
import org.apache.iotdb.db.queryengine.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.queryengine.transformation.dag.memory.SafetyLine;
import org.apache.iotdb.db.queryengine.transformation.dag.util.LayerCacheUtils;
import org.apache.iotdb.db.queryengine.transformation.dag.util.TransformUtils;
import org.apache.iotdb.db.queryengine.transformation.datastructure.iterator.TVListForwardIterator;
import org.apache.iotdb.db.queryengine.transformation.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.queryengine.transformation.datastructure.util.ValueRecorder;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.customizer.strategy.SessionTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingTimeWindowAccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.StateWindowAccessStrategy;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputMultiReferenceLayer
extends IntermediateLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleInputMultiReferenceLayer.class);
    private final LayerReader parentLayerReader;
    private final TSDataType parentLayerReaderDataType;
    private final boolean isParentLayerReaderConstant;
    private final ElasticSerializableTVList tvList;
    private final SafetyLine safetyLine;

    public SingleInputMultiReferenceLayer(Expression expression, String queryId, float memoryBudgetInMB, LayerReader parentLayerReader) {
        super(expression, queryId, memoryBudgetInMB);
        this.parentLayerReader = parentLayerReader;
        this.parentLayerReaderDataType = this.parentLayerReader.getDataTypes()[0];
        this.isParentLayerReaderConstant = this.parentLayerReader.isConstantPointReader();
        this.tvList = ElasticSerializableTVList.construct(this.parentLayerReaderDataType, queryId, memoryBudgetInMB, 2);
        this.safetyLine = new SafetyLine();
    }

    @Override
    public LayerReader constructReader() {
        return new LayerReader(){
            private final SafetyLine.SafetyPile safetyPile;
            private Column cachedTimes;
            private Column cachedValues;
            private int cacheConsumed;
            private final TVListForwardIterator iterator;
            {
                this.safetyPile = SingleInputMultiReferenceLayer.this.safetyLine.addSafetyPile();
                this.cachedTimes = null;
                this.cachedValues = null;
                this.cacheConsumed = 0;
                this.iterator = SingleInputMultiReferenceLayer.this.tvList.constructIterator();
            }

            @Override
            public boolean isConstantPointReader() {
                return SingleInputMultiReferenceLayer.this.isParentLayerReaderConstant;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.cachedTimes != null && this.cacheConsumed < this.cachedTimes.getPositionCount()) {
                    return YieldableState.YIELDABLE;
                }
                if (this.iterator.hasNext()) {
                    this.iterator.next();
                    this.cachedTimes = this.iterator.currentTimes();
                    this.cachedValues = this.iterator.currentValues();
                    return YieldableState.YIELDABLE;
                }
                YieldableState state = LayerCacheUtils.yieldPoints(SingleInputMultiReferenceLayer.this.parentLayerReader, SingleInputMultiReferenceLayer.this.tvList);
                if (state == YieldableState.YIELDABLE) {
                    this.iterator.next();
                    this.cachedTimes = this.iterator.currentTimes();
                    this.cachedValues = this.iterator.currentValues();
                }
                return state;
            }

            @Override
            public void consumedAll() {
                int steps = this.cachedTimes.getPositionCount() - this.cacheConsumed;
                this.safetyPile.moveForward(steps);
                SingleInputMultiReferenceLayer.this.tvList.setEvictionUpperBound(SingleInputMultiReferenceLayer.this.safetyLine.getSafetyLine());
                this.cacheConsumed = 0;
                this.cachedTimes = null;
                this.cachedValues = null;
            }

            @Override
            public Column[] current() {
                Column[] columnArray;
                if (this.cacheConsumed == 0) {
                    Column[] columnArray2 = new Column[2];
                    columnArray2[0] = this.cachedValues;
                    columnArray = columnArray2;
                    columnArray2[1] = this.cachedTimes;
                } else {
                    Column[] columnArray3 = new Column[2];
                    columnArray3[0] = this.cachedValues.subColumn(this.cacheConsumed);
                    columnArray = columnArray3;
                    columnArray3[1] = this.cachedTimes.subColumn(this.cacheConsumed);
                }
                return columnArray;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputMultiReferenceLayer.this.parentLayerReaderDataType};
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingSizeWindowReader(final SlidingSizeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        return new LayerRowWindowReader(){
            private final int windowSize;
            private final int slidingStep;
            private final SafetyLine.SafetyPile safetyPile;
            private final ElasticSerializableTVListBackedSingleColumnWindow window;
            private boolean hasCached;
            private int beginIndex;
            {
                this.windowSize = strategy.getWindowSize();
                this.slidingStep = strategy.getSlidingStep();
                this.safetyPile = SingleInputMultiReferenceLayer.this.safetyLine.addSafetyPile();
                this.window = new ElasticSerializableTVListBackedSingleColumnWindow(SingleInputMultiReferenceLayer.this.tvList);
                this.hasCached = false;
                this.beginIndex = -this.slidingStep;
            }

            @Override
            public YieldableState yield() throws Exception {
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                this.beginIndex += this.slidingStep;
                int endIndex = this.beginIndex + this.windowSize;
                if (this.beginIndex < 0 || endIndex < 0) {
                    LOGGER.warn("LayerRowWindowReader index overflow. beginIndex: {}, endIndex: {}, windowSize: {}.", new Object[]{this.beginIndex, endIndex, this.windowSize});
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                int pointsToBeCollected = endIndex - SingleInputMultiReferenceLayer.this.tvList.size();
                if (pointsToBeCollected > 0) {
                    YieldableState yieldableState = LayerCacheUtils.yieldPoints(SingleInputMultiReferenceLayer.this.parentLayerReader, SingleInputMultiReferenceLayer.this.tvList, pointsToBeCollected);
                    if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        this.beginIndex -= this.slidingStep;
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (SingleInputMultiReferenceLayer.this.tvList.size() <= this.beginIndex) {
                        return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                    }
                    endIndex = Math.min(endIndex, SingleInputMultiReferenceLayer.this.tvList.size());
                }
                this.window.seek(this.beginIndex, endIndex, SingleInputMultiReferenceLayer.this.tvList.getTime(this.beginIndex), SingleInputMultiReferenceLayer.this.tvList.getTime(endIndex - 1));
                this.hasCached = true;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.safetyPile.moveForwardTo(this.beginIndex + 1);
                SingleInputMultiReferenceLayer.this.tvList.setEvictionUpperBound(SingleInputMultiReferenceLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputMultiReferenceLayer.this.parentLayerReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return this.window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSlidingTimeWindowReader(SlidingTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long timeInterval = strategy.getTimeInterval();
        final long slidingStep = strategy.getSlidingStep();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final SafetyLine.SafetyPile safetyPile = this.safetyLine.addSafetyPile();
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
        final long nextWindowTimeBeginGivenByStrategy = strategy.getDisplayWindowBegin();
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private boolean hasCached = false;
            private long nextWindowTimeBegin = nextWindowTimeBeginGivenByStrategy;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private long currentEndTime = Long.MAX_VALUE;
            private final TVListForwardIterator beginIterator = SingleInputMultiReferenceLayer.access$100(SingleInputMultiReferenceLayer.this).constructIterator();
            private Column cachedBeginTimeColumn;
            private int cachedBeginConsumed;
            private Column cachedEndTimeColumn;
            private int cachedEndConsumed;

            @Override
            public YieldableState yield() throws Exception {
                if (this.isFirstIteration) {
                    if (SingleInputMultiReferenceLayer.this.tvList.size() == 0) {
                        YieldableState state = SingleInputMultiReferenceLayer.this.parentLayerReader.yield();
                        if (state != YieldableState.YIELDABLE) {
                            return state;
                        }
                        Column[] columns = SingleInputMultiReferenceLayer.this.parentLayerReader.current();
                        TimeColumn times = (TimeColumn)columns[1];
                        Column values = columns[0];
                        SingleInputMultiReferenceLayer.this.tvList.putColumn((Column)times, values);
                        SingleInputMultiReferenceLayer.this.parentLayerReader.consumedAll();
                        this.cachedEndTimeColumn = times;
                    }
                    if (this.nextWindowTimeBegin == Long.MIN_VALUE) {
                        this.nextWindowTimeBegin = this.cachedEndTimeColumn.getLong(0);
                    }
                    boolean bl = this.hasAtLeastOneRow = SingleInputMultiReferenceLayer.this.tvList.size() != 0;
                    if (this.hasAtLeastOneRow) {
                        this.currentEndTime = this.cachedEndTimeColumn.getLong(this.cachedEndTimeColumn.getPositionCount() - 1);
                    }
                    this.isFirstIteration = false;
                }
                if (this.hasCached) {
                    return YieldableState.YIELDABLE;
                }
                if (!this.hasAtLeastOneRow || displayWindowEnd <= this.nextWindowTimeBegin) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long nextWindowTimeEnd = Math.min(this.nextWindowTimeBegin + timeInterval, displayWindowEnd);
                while (this.currentEndTime < nextWindowTimeEnd) {
                    YieldableState state = SingleInputMultiReferenceLayer.this.parentLayerReader.yield();
                    if (state == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state == YieldableState.NOT_YIELDABLE_NO_MORE_DATA) break;
                    Column[] columns = SingleInputMultiReferenceLayer.this.parentLayerReader.current();
                    TimeColumn times = (TimeColumn)columns[1];
                    Column values = columns[0];
                    SingleInputMultiReferenceLayer.this.tvList.putColumn((Column)times, values);
                    SingleInputMultiReferenceLayer.this.parentLayerReader.consumedAll();
                    this.currentEndTime = times.getEndTime();
                    this.nextIndexEnd += this.cachedEndTimeColumn.getPositionCount() - this.cachedEndConsumed;
                    this.cachedEndTimeColumn = times;
                    this.cachedEndConsumed = 0;
                }
                while (this.cachedEndConsumed < this.cachedEndTimeColumn.getPositionCount() && this.cachedEndTimeColumn.getLong(this.cachedEndConsumed) < nextWindowTimeEnd) {
                    ++this.cachedEndConsumed;
                    ++this.nextIndexEnd;
                }
                boolean findNextIndexBegin = false;
                while (!findNextIndexBegin) {
                    while (this.cachedBeginTimeColumn != null && this.cachedBeginConsumed < this.cachedBeginTimeColumn.getPositionCount()) {
                        if (this.cachedBeginTimeColumn.getLong(this.cachedBeginConsumed) >= this.nextWindowTimeBegin) {
                            findNextIndexBegin = true;
                            break;
                        }
                        ++this.cachedBeginConsumed;
                        ++this.nextIndexBegin;
                    }
                    if (findNextIndexBegin) continue;
                    if (this.beginIterator.hasNext()) {
                        this.beginIterator.next();
                        this.cachedBeginConsumed = 0;
                        this.cachedBeginTimeColumn = this.beginIterator.currentTimes();
                        continue;
                    }
                    findNextIndexBegin = true;
                }
                if (this.nextIndexEnd == this.nextIndexBegin && nextWindowTimeEnd < this.cachedEndTimeColumn.getLong(this.cachedEndTimeColumn.getPositionCount() - 1)) {
                    window.setEmptyWindow(this.nextWindowTimeBegin, nextWindowTimeEnd);
                    return YieldableState.YIELDABLE;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeBegin + timeInterval - 1L);
                this.hasCached = this.nextIndexBegin != this.nextIndexEnd || this.nextIndexEnd != SingleInputMultiReferenceLayer.this.tvList.size();
                return this.hasCached ? YieldableState.YIELDABLE : YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
            }

            @Override
            public void readyForNext() {
                this.hasCached = false;
                this.nextWindowTimeBegin += slidingStep;
                safetyPile.moveForwardTo(this.nextIndexBegin + 1);
                SingleInputMultiReferenceLayer.this.tvList.setEvictionUpperBound(SingleInputMultiReferenceLayer.this.safetyLine.getSafetyLine());
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputMultiReferenceLayer.this.parentLayerReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowSessionTimeWindowReader(SessionTimeWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final long sessionTimeGap = strategy.getSessionTimeGap();
        final SafetyLine.SafetyPile safetyPile = this.safetyLine.addSafetyPile();
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private TimeColumn cachedTimes;
            private int cachedConsumed;

            @Override
            public YieldableState yield() throws Exception {
                YieldableState state;
                if (this.isFirstIteration && (state = this.yieldInFirstIteration()) != YieldableState.YIELDABLE) {
                    return state;
                }
                if (!this.hasAtLeastOneRow || this.nextWindowTimeBegin >= displayWindowEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                long curTime = this.cachedTimes.getLong(this.cachedConsumed);
                if (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    ++this.nextIndexEnd;
                    ++this.cachedConsumed;
                }
                boolean findWindow = false;
                while (!findWindow && this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    while (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                        long nextTime = this.cachedTimes.getLong(this.cachedConsumed);
                        if (nextTime >= displayWindowEnd) {
                            findWindow = true;
                            break;
                        }
                        if (nextTime - curTime > sessionTimeGap) {
                            findWindow = true;
                            break;
                        }
                        ++this.nextIndexEnd;
                        ++this.cachedConsumed;
                        curTime = nextTime;
                    }
                    if (findWindow || this.cachedTimes.getEndTime() >= displayWindowEnd) continue;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state2 != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                this.nextWindowTimeEnd = SingleInputMultiReferenceLayer.this.tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldInFirstIteration() throws Exception {
                YieldableState state;
                if (SingleInputMultiReferenceLayer.this.tvList.size() == 0 && (state = this.yieldAndCache()) != YieldableState.YIELDABLE) {
                    return state;
                }
                this.nextWindowTimeBegin = Math.max(displayWindowBegin, this.cachedTimes.getStartTime());
                this.hasAtLeastOneRow = SingleInputMultiReferenceLayer.this.tvList.size() != 0;
                this.isFirstIteration = false;
                long currentEndTime = this.cachedTimes.getEndTime();
                while (currentEndTime < this.nextWindowTimeBegin) {
                    this.cachedConsumed = this.cachedTimes.getPositionCount();
                    this.nextIndexBegin += this.cachedConsumed;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.YIELDABLE) continue;
                    this.nextIndexEnd = this.nextIndexBegin;
                    return state2;
                }
                while (this.cachedConsumed < this.cachedTimes.getPositionCount() && this.cachedTimes.getLong(this.cachedConsumed) < this.nextWindowTimeBegin) {
                    ++this.cachedConsumed;
                    ++this.nextIndexBegin;
                }
                this.nextIndexEnd = this.nextIndexBegin;
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldAndCache() throws Exception {
                YieldableState state = SingleInputMultiReferenceLayer.this.parentLayerReader.yield();
                if (state != YieldableState.YIELDABLE) {
                    return state;
                }
                Column[] columns = SingleInputMultiReferenceLayer.this.parentLayerReader.current();
                TimeColumn times = (TimeColumn)columns[1];
                Column values = columns[0];
                SingleInputMultiReferenceLayer.this.tvList.putColumn((Column)times, values);
                SingleInputMultiReferenceLayer.this.parentLayerReader.consumedAll();
                this.cachedTimes = times;
                this.cachedConsumed = 0;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() throws IOException {
                if (this.nextIndexEnd < SingleInputMultiReferenceLayer.this.tvList.size()) {
                    this.nextWindowTimeBegin = SingleInputMultiReferenceLayer.this.tvList.getTime(this.nextIndexEnd);
                }
                safetyPile.moveForwardTo(this.nextIndexBegin + 1);
                SingleInputMultiReferenceLayer.this.tvList.setEvictionUpperBound(SingleInputMultiReferenceLayer.this.safetyLine.getSafetyLine());
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputMultiReferenceLayer.this.parentLayerReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }

    @Override
    protected LayerRowWindowReader constructRowStateWindowReader(StateWindowAccessStrategy strategy, float memoryBudgetInMB) {
        final long displayWindowBegin = strategy.getDisplayWindowBegin();
        final long displayWindowEnd = strategy.getDisplayWindowEnd();
        final double delta = strategy.getDelta();
        final SafetyLine.SafetyPile safetyPile = this.safetyLine.addSafetyPile();
        final ElasticSerializableTVListBackedSingleColumnWindow window = new ElasticSerializableTVListBackedSingleColumnWindow(this.tvList);
        return new LayerRowWindowReader(){
            private boolean isFirstIteration = true;
            private boolean hasAtLeastOneRow = false;
            private long nextWindowTimeBegin = displayWindowBegin;
            private long nextWindowTimeEnd = 0L;
            private int nextIndexBegin = 0;
            private int nextIndexEnd = 0;
            private TimeColumn cachedTimes;
            private Column cachedValues;
            private int cachedConsumed;
            private final ValueRecorder valueRecorder = new ValueRecorder();

            @Override
            public YieldableState yield() throws Exception {
                YieldableState state;
                if (this.isFirstIteration && (state = this.yieldInFirstIteration()) != YieldableState.YIELDABLE) {
                    return state;
                }
                if (!this.hasAtLeastOneRow || this.nextWindowTimeBegin >= displayWindowEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                if (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    ++this.nextIndexEnd;
                    ++this.cachedConsumed;
                }
                boolean findWindow = false;
                while (!findWindow && this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                    while (this.cachedConsumed < this.cachedTimes.getPositionCount()) {
                        long nextTime = this.cachedTimes.getLong(this.cachedConsumed);
                        if (nextTime >= displayWindowEnd) {
                            findWindow = true;
                            break;
                        }
                        if (TransformUtils.splitWindowForStateWindow(SingleInputMultiReferenceLayer.this.parentLayerReaderDataType, this.valueRecorder, delta, this.cachedValues, this.cachedConsumed)) {
                            findWindow = true;
                            break;
                        }
                        ++this.nextIndexEnd;
                        ++this.cachedConsumed;
                    }
                    if (findWindow || this.cachedTimes.getEndTime() >= displayWindowEnd) continue;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                        return YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA;
                    }
                    if (state2 != YieldableState.NOT_YIELDABLE_NO_MORE_DATA) continue;
                    break;
                }
                this.nextWindowTimeEnd = SingleInputMultiReferenceLayer.this.tvList.getTime(this.nextIndexEnd - 1);
                if (this.nextIndexBegin == this.nextIndexEnd) {
                    return YieldableState.NOT_YIELDABLE_NO_MORE_DATA;
                }
                window.seek(this.nextIndexBegin, this.nextIndexEnd, this.nextWindowTimeBegin, this.nextWindowTimeEnd);
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldInFirstIteration() throws Exception {
                YieldableState state;
                if (SingleInputMultiReferenceLayer.this.tvList.size() == 0 && (state = this.yieldAndCache()) != YieldableState.YIELDABLE) {
                    return state;
                }
                this.nextWindowTimeBegin = Math.max(displayWindowBegin, this.cachedTimes.getStartTime());
                this.hasAtLeastOneRow = SingleInputMultiReferenceLayer.this.tvList.size() != 0;
                this.isFirstIteration = false;
                long currentEndTime = this.cachedTimes.getEndTime();
                while (currentEndTime < this.nextWindowTimeBegin) {
                    this.cachedConsumed = this.cachedTimes.getPositionCount();
                    this.nextIndexBegin += this.cachedConsumed;
                    YieldableState state2 = this.yieldAndCache();
                    if (state2 == YieldableState.YIELDABLE) continue;
                    this.nextIndexEnd = this.nextIndexBegin;
                    return state2;
                }
                while (this.cachedConsumed < this.cachedTimes.getPositionCount() && this.cachedTimes.getLong(this.cachedConsumed) < this.nextWindowTimeBegin) {
                    ++this.cachedConsumed;
                    ++this.nextIndexBegin;
                }
                this.nextIndexEnd = this.nextIndexBegin;
                return YieldableState.YIELDABLE;
            }

            private YieldableState yieldAndCache() throws Exception {
                YieldableState state = SingleInputMultiReferenceLayer.this.parentLayerReader.yield();
                if (state != YieldableState.YIELDABLE) {
                    return state;
                }
                Column[] columns = SingleInputMultiReferenceLayer.this.parentLayerReader.current();
                TimeColumn times = (TimeColumn)columns[1];
                Column values = columns[0];
                SingleInputMultiReferenceLayer.this.tvList.putColumn((Column)times, values);
                SingleInputMultiReferenceLayer.this.parentLayerReader.consumedAll();
                this.cachedTimes = times;
                this.cachedValues = values;
                this.cachedConsumed = 0;
                return YieldableState.YIELDABLE;
            }

            @Override
            public void readyForNext() throws IOException {
                if (this.nextIndexEnd < SingleInputMultiReferenceLayer.this.tvList.size()) {
                    this.nextWindowTimeBegin = SingleInputMultiReferenceLayer.this.tvList.getTime(this.nextIndexEnd);
                }
                safetyPile.moveForwardTo(this.nextIndexBegin + 1);
                SingleInputMultiReferenceLayer.this.tvList.setEvictionUpperBound(SingleInputMultiReferenceLayer.this.safetyLine.getSafetyLine());
                this.nextIndexBegin = this.nextIndexEnd;
            }

            @Override
            public TSDataType[] getDataTypes() {
                return new TSDataType[]{SingleInputMultiReferenceLayer.this.parentLayerReaderDataType};
            }

            @Override
            public RowWindow currentWindow() {
                return window;
            }
        };
    }
}

