/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.Reader;
import java.io.StringReader;
import java.time.Clock;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.mime4j.dom.datetime.DateTime;
import org.apache.james.mime4j.field.datetime.parser.DateTimeParser;
import org.apache.james.mime4j.field.datetime.parser.ParseException;
import org.apache.james.util.DurationParser;
import org.apache.mailet.Mail;
import org.apache.mailet.base.DateFormats;
import org.apache.mailet.base.GenericMailet;

public class Expires
extends GenericMailet {
    public static final String EXPIRES = "Expires";
    private final Clock clock;
    private Optional<Duration> minAge = Optional.empty();
    private Optional<Duration> maxAge = Optional.empty();
    private Optional<Duration> defaultAge = Optional.empty();

    @Inject
    public Expires(Clock clock) {
        this.clock = clock;
    }

    public void init() throws MessagingException {
        this.minAge = this.parseDuration("minAge");
        this.maxAge = this.parseDuration("maxAge");
        this.defaultAge = this.parseDuration("defaultAge");
        if (this.minAge.isEmpty() && this.maxAge.isEmpty() && this.defaultAge.isEmpty()) {
            throw new MessagingException("Please configure at least one of minAge, maxAge, defaultAge");
        }
        if (this.isAfter(this.minAge, this.maxAge)) {
            throw new MessagingException("minAge must be before maxAge");
        }
        if (this.isAfter(this.defaultAge, this.maxAge)) {
            throw new MessagingException("defaultAge must be before maxAge");
        }
        if (this.isAfter(this.minAge, this.defaultAge)) {
            throw new MessagingException("minAge must be before defaultAge");
        }
    }

    public void service(Mail mail) throws MessagingException {
        ZonedDateTime now = ZonedDateTime.now(this.clock);
        MimeMessage message = mail.getMessage();
        Optional<ZonedDateTime> expires = this.parseExpiresHeader(message);
        if (expires.isPresent()) {
            if (this.minAge.isPresent() && expires.get().isBefore(now.plus(this.minAge.get()))) {
                this.setExpiresAfter(message, now, this.minAge.get());
            } else if (this.maxAge.isPresent() && expires.get().isAfter(now.plus(this.maxAge.get()))) {
                this.setExpiresAfter(message, now, this.maxAge.get());
            }
        } else if (this.defaultAge.isPresent()) {
            this.setExpiresAfter(message, now, this.defaultAge.get());
        }
    }

    public String getMailetInfo() {
        return "Expire Mailet";
    }

    private Optional<Duration> parseDuration(String param) {
        return Optional.ofNullable(this.getInitParameter(param)).map(duration -> DurationParser.parse((String)duration, (ChronoUnit)ChronoUnit.DAYS));
    }

    private boolean isAfter(Optional<Duration> a, Optional<Duration> b) {
        return a.isPresent() && b.isPresent() && a.get().compareTo(b.get()) > 0;
    }

    private Optional<ZonedDateTime> parseExpiresHeader(MimeMessage message) {
        try {
            String[] expires = message.getHeader(EXPIRES);
            if (expires == null || expires.length == 0) {
                return Optional.empty();
            }
            DateTime dt = new DateTimeParser((Reader)new StringReader(expires[0])).parseAll();
            return Optional.of(ZonedDateTime.of(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getHour(), dt.getMinute(), dt.getSecond(), 0, ZoneOffset.ofHoursMinutes(dt.getTimeZone() / 100, dt.getTimeZone() % 100)));
        }
        catch (MessagingException | ParseException e) {
            return Optional.empty();
        }
    }

    private void setExpiresAfter(MimeMessage message, ZonedDateTime now, Duration age) throws MessagingException {
        message.setHeader(EXPIRES, DateFormats.RFC822_DATE_FORMAT.format(now.plus(age)));
        message.saveChanges();
    }
}

