/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.quota;

import java.util.Map;
import javax.inject.Inject;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class StoreQuotaManager
implements QuotaManager {
    private final CurrentQuotaManager currentQuotaManager;
    private final MaxQuotaManager maxQuotaManager;

    @Inject
    public StoreQuotaManager(CurrentQuotaManager currentQuotaManager, MaxQuotaManager maxQuotaManager) {
        this.currentQuotaManager = currentQuotaManager;
        this.maxQuotaManager = maxQuotaManager;
    }

    public Quota<QuotaCountLimit, QuotaCountUsage> getMessageQuota(QuotaRoot quotaRoot) {
        Map maxMessageDetails = this.maxQuotaManager.listMaxMessagesDetails(quotaRoot);
        return Quota.builder().used((QuotaUsageValue)((QuotaCountUsage)Mono.from((Publisher)this.currentQuotaManager.getCurrentMessageCount(quotaRoot)).block()).sanitize()).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxMessage(maxMessageDetails).orElse(QuotaCountLimit.unlimited())).limitsByScope(maxMessageDetails).build();
    }

    public Quota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(QuotaRoot quotaRoot) {
        Map maxStorageDetails = this.maxQuotaManager.listMaxStorageDetails(quotaRoot);
        return Quota.builder().used((QuotaUsageValue)((QuotaSizeUsage)Mono.from((Publisher)this.currentQuotaManager.getCurrentStorage(quotaRoot)).block()).sanitize()).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxStorage(maxStorageDetails).orElse(QuotaSizeLimit.unlimited())).limitsByScope(maxStorageDetails).build();
    }

    public QuotaManager.Quotas getQuotas(QuotaRoot quotaRoot) {
        MaxQuotaManager.QuotaDetails quotaDetails = this.maxQuotaManager.quotaDetails(quotaRoot);
        CurrentQuotas.Sanitized currentQuotas = ((CurrentQuotas)Mono.from((Publisher)this.currentQuotaManager.getCurrentQuotas(quotaRoot)).block()).sanitize();
        return new QuotaManager.Quotas(Quota.builder().used((QuotaUsageValue)currentQuotas.count()).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxMessage(quotaDetails.getMaxMessageDetails()).orElse(QuotaCountLimit.unlimited())).limitsByScope(quotaDetails.getMaxMessageDetails()).build(), Quota.builder().used((QuotaUsageValue)currentQuotas.size()).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxStorage(quotaDetails.getMaxStorageDetails()).orElse(QuotaSizeLimit.unlimited())).limitsByScope(quotaDetails.getMaxStorageDetails()).build());
    }

    public Publisher<QuotaManager.Quotas> getQuotasReactive(QuotaRoot quotaRoot) {
        return Mono.zip((Mono)Mono.from((Publisher)this.maxQuotaManager.quotaDetailsReactive(quotaRoot)), (Mono)Mono.from((Publisher)this.currentQuotaManager.getCurrentQuotas(quotaRoot)).map(CurrentQuotas::sanitize)).map(tuple -> new QuotaManager.Quotas(Quota.builder().used((QuotaUsageValue)((CurrentQuotas.Sanitized)tuple.getT2()).count()).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxMessage(((MaxQuotaManager.QuotaDetails)tuple.getT1()).getMaxMessageDetails()).orElse(QuotaCountLimit.unlimited())).limitsByScope(((MaxQuotaManager.QuotaDetails)tuple.getT1()).getMaxMessageDetails()).build(), Quota.builder().used((QuotaUsageValue)((CurrentQuotas.Sanitized)tuple.getT2()).size()).computedLimit((QuotaLimitValue)this.maxQuotaManager.getMaxStorage(((MaxQuotaManager.QuotaDetails)tuple.getT1()).getMaxStorageDetails()).orElse(QuotaSizeLimit.unlimited())).limitsByScope(((MaxQuotaManager.QuotaDetails)tuple.getT1()).getMaxStorageDetails()).build()));
    }
}

