/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.event;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.event.json.MailboxEventSerializer;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusId;
import org.apache.james.events.EventBusReconnectionHandler;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.KeyReconnectionHandler;
import org.apache.james.events.NamingStrategy;
import org.apache.james.events.RabbitEventBusConsumerHealthCheck;
import org.apache.james.events.RabbitMQEventBus;
import org.apache.james.events.RabbitMQEventBusDeadLetterQueueHealthCheck;
import org.apache.james.events.RegistrationKey;
import org.apache.james.events.RetryBackoffConfiguration;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class RabbitMQEventBusModule
extends AbstractModule {
    protected void configure() {
        this.bind(MailboxEventSerializer.class).in(Scopes.SINGLETON);
        this.bind(EventSerializer.class).to(MailboxEventSerializer.class);
        this.bind(NamingStrategy.class).toInstance((Object)NamingStrategy.MAILBOX_EVENT_NAMING_STRATEGY);
        this.bind(RabbitMQEventBus.class).in(Scopes.SINGLETON);
        this.bind(EventBus.class).to(RabbitMQEventBus.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventBus.class).addBinding().to(EventBus.class);
        Multibinder.newSetBinder((Binder)this.binder(), RegistrationKey.Factory.class).addBinding().to(MailboxIdRegistrationKey.Factory.class);
        this.bind(RetryBackoffConfiguration.class).toInstance((Object)RetryBackoffConfiguration.DEFAULT);
        this.bind(EventBusId.class).toInstance((Object)EventBusId.random());
        Multibinder reconnectionHandlerMultibinder = Multibinder.newSetBinder((Binder)this.binder(), SimpleConnectionPool.ReconnectionHandler.class);
        reconnectionHandlerMultibinder.addBinding().to(KeyReconnectionHandler.class);
        reconnectionHandlerMultibinder.addBinding().to(EventBusReconnectionHandler.class);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(RabbitMQEventBusDeadLetterQueueHealthCheck.class);
    }

    @ProvidesIntoSet
    HealthCheck healthCheck(RabbitMQEventBus eventBus, NamingStrategy namingStrategy, SimpleConnectionPool connectionPool) {
        return new RabbitEventBusConsumerHealthCheck(eventBus, namingStrategy, connectionPool);
    }

    @ProvidesIntoSet
    InitializationOperation workQueue(RabbitMQEventBus instance) {
        return InitilizationOperationBuilder.forClass(RabbitMQEventBus.class).init(() -> ((RabbitMQEventBus)instance).start());
    }
}

