/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Test;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;
import static org.w3c.domts.DOMTest.load;


/**
 * The method setAttributeNodeNS adds a new attribute and raises the
 * INUSE_ATTRIBUTE_ERR exception if the newAttr is already an attribute of
 * another Element object.
 * Retreive an attribute node of an existing element node.  Attempt to add it to an another
 * element node.  Check if the INUSE_ATTRIBUTE_ERR exception is thrown.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS">http://www.w3.org/TR/DOM-Level-2-Core/core#ID-ElSetAtNodeNS</a>
 */
public class elementsetattributenodens03 {
    @Test
    void testRun() throws Throwable {
        String nullNS = null;

        Document doc = load("staffNS", true);
        NodeList elementList = doc.getElementsByTagNameNS("http://www.nist.gov", "address");
        Element element1 = (Element) elementList.item(1);
        Attr attribute = element1.getAttributeNodeNS(nullNS, "street");
        Element element2 = (Element) elementList.item(2);

        DOMException ex = assertThrows(DOMException.class, () -> element2.setAttributeNodeNS(attribute));
        assertEquals(DOMException.INUSE_ATTRIBUTE_ERR, ex.code, "elementsetattributenodens03");
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/elementsetattributenodens03";
    }

}
