/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v4x;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebExchangeDecorator;

public class NettyRoutingFilterInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String NETTY_ROUTING_FILTER_TRACED_ATTR = NettyRoutingFilterInterceptor.class.getName() + ".isTraced";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
        if (NettyRoutingFilterInterceptor.isTraced(exchange)) {
            return;
        }
        NettyRoutingFilterInterceptor.setTracedStatus(exchange);
        EnhancedInstance enhancedInstance = this.getInstance(allArguments[0]);
        AbstractSpan span = ContextManager.createLocalSpan((String)"SpringCloudGateway/RoutingFilter");
        if (enhancedInstance != null && enhancedInstance.getSkyWalkingDynamicField() != null) {
            ContextManager.continued((ContextSnapshot)((ContextSnapshot)enhancedInstance.getSkyWalkingDynamicField()));
        }
        span.setComponent((Component)ComponentsDefine.SPRING_CLOUD_GATEWAY);
    }

    private static void setTracedStatus(ServerWebExchange exchange) {
        exchange.getAttributes().put(NETTY_ROUTING_FILTER_TRACED_ATTR, true);
    }

    private static boolean isTraced(ServerWebExchange exchange) {
        return (Boolean)exchange.getAttributeOrDefault(NETTY_ROUTING_FILTER_TRACED_ATTR, (Object)false);
    }

    private EnhancedInstance getInstance(Object o) {
        EnhancedInstance instance = null;
        if (o instanceof EnhancedInstance) {
            instance = (EnhancedInstance)o;
        } else if (o instanceof ServerWebExchangeDecorator) {
            ServerWebExchange delegate = ((ServerWebExchangeDecorator)o).getDelegate();
            return this.getInstance(delegate);
        }
        return instance;
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

