/**
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The ASF licenses this file to you under the Apache License, Version
 * 2.0 (the "License"); you may not use this file except in compliance with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package org.apache.storm.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MkTupleParam {
    private String stream;
    private String component;
    private List<String> fields;

    public String getStream() {
        return stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public String getComponent() {
        return component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(String... fields) {
        this.fields = new ArrayList<>(Arrays.asList(fields));
    }

    public void setFieldsList(List<String> fields) {
        if (fields != null) {
            this.fields = new ArrayList<>(fields);
        } else {
            this.fields = null;
        }
    }
}
