/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.functors;

import java.io.Serializable;
import java.util.Objects;
import org.apache.storm.shade.org.apache.commons.collections4.Equator;
import org.apache.storm.shade.org.apache.commons.collections4.Predicate;
import org.apache.storm.shade.org.apache.commons.collections4.functors.AbstractPredicate;
import org.apache.storm.shade.org.apache.commons.collections4.functors.NullPredicate;

public final class EqualPredicate<T>
extends AbstractPredicate<T>
implements Serializable {
    private static final long serialVersionUID = 5633766978029907089L;
    private final T test;
    private final Equator<T> equator;

    public static <T> Predicate<T> equalPredicate(T object) {
        if (object == null) {
            return NullPredicate.nullPredicate();
        }
        return new EqualPredicate<T>(object);
    }

    public static <T> Predicate<T> equalPredicate(T object, Equator<T> equator) {
        if (object == null) {
            return NullPredicate.nullPredicate();
        }
        return new EqualPredicate<T>(object, equator);
    }

    public EqualPredicate(T object) {
        this(object, null);
    }

    public EqualPredicate(T test, Equator<T> equator) {
        this.test = test;
        this.equator = equator;
    }

    public Object getValue() {
        return this.test;
    }

    @Override
    public boolean test(T object) {
        if (this.equator != null) {
            return this.equator.equate(this.test, object);
        }
        return Objects.equals(this.test, object);
    }
}

