/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.imps;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.shade.org.apache.curator.drivers.OperationTrace;
import org.apache.storm.shade.org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEventType;
import org.apache.storm.shade.org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.storm.shade.org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.storm.shade.org.apache.curator.framework.imps.CreateBuilderImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.storm.shade.org.apache.curator.framework.imps.OperationAndData;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.org.apache.curator.utils.ThreadUtils;
import org.apache.storm.shade.org.apache.curator.utils.ZKPaths;
import org.apache.storm.shade.org.apache.zookeeper.AsyncCallback;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FindAndDeleteProtectedNodeInBackground
implements BackgroundOperation<Void> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFrameworkBase client;
    private final String namespaceAdjustedParentPath;
    private final String protectedId;
    @VisibleForTesting
    static final AtomicBoolean debugInsertError = new AtomicBoolean(false);

    FindAndDeleteProtectedNodeInBackground(CuratorFrameworkBase client, String namespaceAdjustedParentPath, String protectedId) {
        this.client = client;
        this.namespaceAdjustedParentPath = namespaceAdjustedParentPath;
        this.protectedId = protectedId;
    }

    void execute() {
        OperationAndData.ErrorCallback<Void> errorCallback = new OperationAndData.ErrorCallback<Void>(){

            @Override
            public void retriesExhausted(OperationAndData<Void> operationAndData) {
                operationAndData.reset();
                FindAndDeleteProtectedNodeInBackground.this.client.processBackgroundOperation(operationAndData, null);
            }
        };
        OperationAndData<Void> operationAndData = new OperationAndData<Void>(this, null, null, errorCallback, null, null);
        this.client.processBackgroundOperation(operationAndData, null);
    }

    @Override
    public CuratorEventType getBackgroundEventType() {
        return CuratorEventType.CHILDREN;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<Void> operationAndData) throws Exception {
        final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("FindAndDeleteProtectedNodeInBackground");
        AsyncCallback.Children2Callback callback = new AsyncCallback.Children2Callback(){
            final /* synthetic */ FindAndDeleteProtectedNodeInBackground this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void processResult(int rc, String path, Object o, List<String> strings, Stat stat) {
                String node;
                trace.setReturnCode(rc).setPath(path).setStat(stat).commit();
                if (debugInsertError.compareAndSet(true, false)) {
                    rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                }
                if (rc == KeeperException.Code.OK.intValue() && (node = CreateBuilderImpl.findNode(strings, "/", this.this$0.protectedId)) != null) {
                    try {
                        String deletePath = this.this$0.client.unfixForNamespace(ZKPaths.makePath(this.this$0.namespaceAdjustedParentPath, node));
                        ((ErrorListenerPathable)((ChildrenDeletable)this.this$0.client.delete().guaranteed()).inBackground()).forPath(deletePath);
                    }
                    catch (Exception e) {
                        ThreadUtils.checkInterrupted(e);
                        this.this$0.log.error("Could not start guaranteed delete for node: " + node);
                        rc = KeeperException.Code.CONNECTIONLOSS.intValue();
                    }
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    CuratorEventImpl event = new CuratorEventImpl(this.this$0.client, CuratorEventType.CHILDREN, rc, path, null, o, stat, null, strings, null, null, null);
                    this.this$0.client.processBackgroundOperation(operationAndData, event);
                }
            }
        };
        this.client.getZooKeeper().getChildren(this.namespaceAdjustedParentPath, false, callback, null);
    }
}

