/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.scheduler.resource.normalization.NormalizedResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);

    public static NormalizedResourceRequest getBoltResources(StormTopology topology, Map<String, Object> topologyConf, String componentId) {
        if (topology.get_bolts() != null) {
            Bolt bolt = (Bolt)topology.get_bolts().get(componentId);
            return new NormalizedResourceRequest(bolt.get_common(), topologyConf, componentId);
        }
        return null;
    }

    public static Map<String, NormalizedResourceRequest> getBoltsResources(StormTopology topology, Map<String, Object> topologyConf) {
        HashMap<String, NormalizedResourceRequest> boltResources = new HashMap<String, NormalizedResourceRequest>();
        if (topology.get_bolts() != null) {
            for (Map.Entry bolt : topology.get_bolts().entrySet()) {
                NormalizedResourceRequest topologyResources = new NormalizedResourceRequest(((Bolt)bolt.getValue()).get_common(), topologyConf, (String)bolt.getKey());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Turned {} into {}", (Object)((Bolt)bolt.getValue()).get_common().get_json_conf(), (Object)topologyResources);
                }
                boltResources.put((String)bolt.getKey(), topologyResources);
            }
        }
        return boltResources;
    }

    public static NormalizedResourceRequest getSpoutResources(StormTopology topology, Map<String, Object> topologyConf, String componentId) {
        if (topology.get_spouts() != null) {
            SpoutSpec spout = (SpoutSpec)topology.get_spouts().get(componentId);
            return new NormalizedResourceRequest(spout.get_common(), topologyConf, componentId);
        }
        return null;
    }

    public static Map<String, NormalizedResourceRequest> getSpoutsResources(StormTopology topology, Map<String, Object> topologyConf) {
        HashMap<String, NormalizedResourceRequest> spoutResources = new HashMap<String, NormalizedResourceRequest>();
        if (topology.get_spouts() != null) {
            for (Map.Entry spout : topology.get_spouts().entrySet()) {
                NormalizedResourceRequest topologyResources = new NormalizedResourceRequest(((SpoutSpec)spout.getValue()).get_common(), topologyConf, (String)spout.getKey());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Turned {} into {}", (Object)((SpoutSpec)spout.getValue()).get_common().get_json_conf(), (Object)topologyResources);
                }
                spoutResources.put((String)spout.getKey(), topologyResources);
            }
        }
        return spoutResources;
    }

    public static void updateStormTopologyResources(StormTopology topology, Map<String, Map<String, Double>> resourceUpdatesMap) {
        String newJsonConf;
        Map<String, Double> resourcesUpdate;
        HashMap<String, Map<String, Double>> componentsUpdated = new HashMap<String, Map<String, Double>>();
        if (topology.get_spouts() != null) {
            for (Map.Entry spout : topology.get_spouts().entrySet()) {
                SpoutSpec spoutSpec = (SpoutSpec)spout.getValue();
                String spoutName = (String)spout.getKey();
                if (!resourceUpdatesMap.containsKey(spoutName)) continue;
                ComponentCommon spoutCommon = spoutSpec.get_common();
                resourcesUpdate = NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(resourceUpdatesMap.get(spoutName));
                newJsonConf = ResourceUtils.getJsonWithUpdatedResources(spoutCommon.get_json_conf(), resourcesUpdate);
                spoutCommon.set_json_conf(newJsonConf);
                componentsUpdated.put(spoutName, resourcesUpdate);
            }
        }
        if (topology.get_bolts() != null) {
            for (Map.Entry bolt : topology.get_bolts().entrySet()) {
                Bolt boltObj = (Bolt)bolt.getValue();
                String boltName = (String)bolt.getKey();
                if (!resourceUpdatesMap.containsKey(boltName)) continue;
                ComponentCommon boltCommon = boltObj.get_common();
                resourcesUpdate = NormalizedResources.RESOURCE_NAME_NORMALIZER.normalizedResourceMap(resourceUpdatesMap.get(boltName));
                newJsonConf = ResourceUtils.getJsonWithUpdatedResources(boltCommon.get_json_conf(), resourceUpdatesMap.get(boltName));
                boltCommon.set_json_conf(newJsonConf);
                componentsUpdated.put(boltName, resourcesUpdate);
            }
        }
        LOG.info("Component resources updated: {}", componentsUpdated);
        HashMap<String, Map<String, Double>> notUpdated = new HashMap<String, Map<String, Double>>();
        for (String component : resourceUpdatesMap.keySet()) {
            if (componentsUpdated.containsKey(component)) continue;
            notUpdated.put(component, resourceUpdatesMap.get(component));
        }
        LOG.info("Component resource updates ignored: {}", notUpdated);
    }

    public static String getCorrespondingLegacyResourceName(String normalizedResourceName) {
        for (Map.Entry<String, String> entry : NormalizedResources.RESOURCE_NAME_NORMALIZER.getResourceNameMapping().entrySet()) {
            if (!entry.getValue().equals(normalizedResourceName)) continue;
            return entry.getKey();
        }
        return normalizedResourceName;
    }

    public static String getJsonWithUpdatedResources(String jsonConf, Map<String, Double> resourceUpdates) {
        try {
            JSONParser parser = new JSONParser();
            Object obj = parser.parse(jsonConf);
            JSONObject jsonObject = (JSONObject)obj;
            Map componentResourceMap = (Map)jsonObject.getOrDefault((Object)"topology.component.resources.map", new HashMap());
            for (Map.Entry<String, Double> resourceUpdateEntry : resourceUpdates.entrySet()) {
                if (NormalizedResources.RESOURCE_NAME_NORMALIZER.getResourceNameMapping().containsValue(resourceUpdateEntry.getKey())) {
                    jsonObject.remove((Object)ResourceUtils.getCorrespondingLegacyResourceName(resourceUpdateEntry.getKey()));
                    componentResourceMap.remove(ResourceUtils.getCorrespondingLegacyResourceName(resourceUpdateEntry.getKey()));
                }
                componentResourceMap.put(resourceUpdateEntry.getKey(), resourceUpdateEntry.getValue());
            }
            jsonObject.put((Object)"topology.component.resources.map", (Object)componentResourceMap);
            return jsonObject.toJSONString();
        }
        catch (ParseException ex) {
            throw new RuntimeException("Failed to parse component resources with json: " + jsonConf);
        }
    }
}

