/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.storm.scheduler.utils.IConfigLoader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigLoader
implements IConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FileConfigLoader.class);
    private Map<String, Object> conf;
    private String targetFilePath = null;

    public FileConfigLoader(Map<String, Object> conf) {
        this.conf = conf;
        String uriString = (String)conf.get("scheduler.config.loader.uri");
        if (uriString == null) {
            LOG.error("No URI defined in {} configuration.", (Object)"scheduler.config.loader.uri");
        } else {
            try {
                this.targetFilePath = new URI(uriString).getPath();
            }
            catch (URISyntaxException e) {
                LOG.error("Failed to parse uri={}", (Object)uriString);
            }
        }
    }

    public Map<String, Object> load(String configKey) {
        if (this.targetFilePath != null) {
            try {
                Map raw = (Map)Utils.readYamlFile((String)this.targetFilePath);
                if (raw != null) {
                    return (Map)raw.get(configKey);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to load from file {}", (Object)this.targetFilePath);
            }
        }
        return null;
    }
}

