/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.validation.ConfigValidation;

public class DaemonConfigValidation {

    public static class NumaEntryValidator
    extends ConfigValidation.Validator {
        public void validateField(String name, Object o) {
            if (o == null) {
                return;
            }
            Map numa = (Map)o;
            for (String key : new String[]{"numa.cores", "numa.memory.mb", "numa.ports"}) {
                if (numa.containsKey(key)) continue;
                throw new IllegalArgumentException("The numa configuration key [" + key + "] is missing!");
            }
            List cores = (List)numa.get("numa.cores");
            HashSet coreSet = new HashSet();
            coreSet.addAll(cores);
            if (coreSet.size() != cores.size()) {
                throw new IllegalArgumentException("Duplicate cores in NUMA config");
            }
            try {
                Map map = numa.getOrDefault("numa.generic.resources.map", Collections.EMPTY_MAP);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid generic resources in NUMA config");
            }
        }
    }
}

