/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.util.List;
import java.util.Map;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.utils.ListDelegate;

public class KryoValuesDeserializer {
    Kryo kryo;
    Input kryoInput;

    public KryoValuesDeserializer(Map<String, Object> conf) {
        this.kryo = SerializationFactory.getKryo(conf);
        this.kryoInput = new Input(1);
    }

    public List<Object> deserializeFrom(Input input) {
        ListDelegate delegate = (ListDelegate)this.kryo.readObject(input, ListDelegate.class);
        return delegate.getDelegate();
    }

    public List<Object> deserialize(byte[] ser) {
        this.kryoInput.setBuffer(ser);
        return this.deserializeFrom(this.kryoInput);
    }

    public Object deserializeObject(byte[] ser) {
        this.kryoInput.setBuffer(ser);
        return this.kryo.readClassAndObject(this.kryoInput);
    }
}

