/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.fluent;

import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.fluent.ChainedAggregatorDeclarer;
import org.apache.storm.trident.fluent.GlobalAggregationScheme;
import org.apache.storm.trident.fluent.IAggregatableStream;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.ReducerAggregator;
import org.apache.storm.trident.operation.impl.GroupedAggregator;
import org.apache.storm.trident.operation.impl.SingleEmitAggregator;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateSpec;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.state.map.MapCombinerAggStateUpdater;
import org.apache.storm.trident.state.map.MapReducerAggStateUpdater;
import org.apache.storm.trident.util.TridentUtils;
import org.apache.storm.tuple.Fields;

public class GroupedStream
implements IAggregatableStream,
GlobalAggregationScheme<GroupedStream> {
    Fields groupFields;
    Stream stream;

    public GroupedStream(Stream stream, Fields groupFields) {
        this.groupFields = groupFields;
        this.stream = stream;
    }

    public GroupedStream name(String name) {
        return new GroupedStream(this.stream.name(name), this.groupFields);
    }

    public ChainedAggregatorDeclarer chainedAgg() {
        return new ChainedAggregatorDeclarer(this, this);
    }

    public Stream aggregate(Aggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        return new ChainedAggregatorDeclarer(this, this).aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return new ChainedAggregatorDeclarer(this, this).aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return new ChainedAggregatorDeclarer(this, this).aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public TridentState persistentAggregate(StateFactory stateFactory, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(inputFields, agg, functionFields).partitionPersist(spec, TridentUtils.fieldsUnion(this.groupFields, functionFields), (StateUpdater)new MapCombinerAggStateUpdater(agg, this.groupFields, functionFields), TridentUtils.fieldsConcat(this.groupFields, functionFields));
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.stream.partitionBy(this.groupFields).partitionPersist(spec, TridentUtils.fieldsUnion(this.groupFields, inputFields), (StateUpdater)new MapReducerAggStateUpdater(agg, this.groupFields, inputFields), TridentUtils.fieldsConcat(this.groupFields, functionFields));
    }

    public TridentState persistentAggregate(StateFactory stateFactory, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public Stream stateQuery(TridentState state, Fields inputFields, QueryFunction function, Fields functionFields) {
        return this.stream.partitionBy(this.groupFields).stateQuery(state, inputFields, function, functionFields);
    }

    public Stream stateQuery(TridentState state, QueryFunction function, Fields functionFields) {
        return this.stateQuery(state, null, function, functionFields);
    }

    @Override
    public IAggregatableStream each(Fields inputFields, Function function, Fields functionFields) {
        Stream s = this.stream.each(inputFields, function, functionFields);
        return new GroupedStream(s, this.groupFields);
    }

    @Override
    public IAggregatableStream partitionAggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        GroupedAggregator groupedAgg = new GroupedAggregator(agg, this.groupFields, inputFields, functionFields.size());
        Fields allInFields = TridentUtils.fieldsUnion(this.groupFields, inputFields);
        Fields allOutFields = TridentUtils.fieldsConcat(this.groupFields, functionFields);
        Stream s = this.stream.partitionAggregate(allInFields, groupedAgg, allOutFields);
        return new GroupedStream(s, this.groupFields);
    }

    @Override
    public IAggregatableStream aggPartition(GroupedStream s) {
        return new GroupedStream(s.stream.partitionBy(this.groupFields), this.groupFields);
    }

    @Override
    public Stream toStream() {
        return this.stream;
    }

    @Override
    public Fields getOutputFields() {
        return this.stream.getOutputFields();
    }

    public Fields getGroupFields() {
        return this.groupFields;
    }

    @Override
    public SingleEmitAggregator.BatchToPartition singleEmitPartitioner() {
        return null;
    }
}

