/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer;

import com.codahale.metrics.Meter;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.daemon.logviewer.utils.DirectoryCleaner;
import org.apache.storm.daemon.logviewer.utils.ExceptionMeterNames;
import org.apache.storm.daemon.logviewer.utils.LogCleaner;
import org.apache.storm.daemon.logviewer.utils.WorkerLogs;
import org.apache.storm.daemon.logviewer.webapp.LogviewerApplication;
import org.apache.storm.daemon.ui.FilterConfiguration;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogviewerServer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LogviewerServer.class);
    private static final String stormHome = System.getProperty("storm.home");
    public static final String STATIC_RESOURCE_DIRECTORY_PATH = stormHome + "/public";
    private final Meter meterShutdownCalls;
    private final Server httpServer;
    private boolean closed = false;

    private static Server mkHttpServer(StormMetricsRegistry metricsRegistry, Map<String, Object> conf) {
        Integer logviewerHttpPort = (Integer)conf.get("logviewer.port");
        Server ret = null;
        if (logviewerHttpPort != null && logviewerHttpPort >= 0) {
            LOG.info("Starting Logviewer HTTP servers...");
            String filterParamKey = "logviewer.filter.params";
            String filterClass = (String)conf.get("logviewer.filter");
            if (StringUtils.isBlank((String)filterClass)) {
                filterClass = (String)conf.get("ui.filter");
                filterParamKey = "ui.filter.params";
            }
            Map filterParams = (Map)conf.get(filterParamKey);
            FilterConfiguration filterConfiguration = new FilterConfiguration(filterClass, filterParams);
            List<FilterConfiguration> filterConfigurations = Arrays.asList(filterConfiguration);
            Integer httpsPort = ObjectReader.getInt((Object)conf.get("logviewer.https.port"), (Integer)0);
            String httpsKsPath = (String)conf.get("logviewer.https.keystore.path");
            String httpsKsPassword = (String)conf.get("logviewer.https.keystore.password");
            String httpsKsType = (String)conf.get("logviewer.https.keystore.type");
            String httpsKeyPassword = (String)conf.get("logviewer.https.key.password");
            String httpsTsPath = (String)conf.get("logviewer.https.truststore.path");
            String httpsTsPassword = (String)conf.get("logviewer.https.truststore.password");
            String httpsTsType = (String)conf.get("logviewer.https.truststore.type");
            Boolean httpsWantClientAuth = (Boolean)conf.get("logviewer.https.want.client.auth");
            Boolean httpsNeedClientAuth = (Boolean)conf.get("logviewer.https.need.client.auth");
            Boolean disableHttpBinding = (Boolean)conf.get("logviewer.disable.http.binding");
            boolean enableSslReload = ObjectReader.getBoolean((Object)conf.get("logviewer.https.enable.ssl.reload"), (boolean)false);
            LogviewerApplication.setup(conf, metricsRegistry);
            ret = UIHelpers.jettyCreateServer(logviewerHttpPort, null, httpsPort, disableHttpBinding);
            UIHelpers.configSsl(ret, httpsPort, httpsKsPath, httpsKsPassword, httpsKsType, httpsKeyPassword, httpsTsPath, httpsTsPassword, httpsTsType, httpsNeedClientAuth, httpsWantClientAuth, enableSslReload);
            ServletContextHandler context = new ServletContextHandler(0);
            try {
                context.setBaseResource(Resource.newResource((String)STATIC_RESOURCE_DIRECTORY_PATH));
            }
            catch (IOException e) {
                throw new RuntimeException("Can't locate static resource directory " + STATIC_RESOURCE_DIRECTORY_PATH);
            }
            context.setWelcomeFiles(new String[]{"logviewer.html"});
            context.setContextPath("/");
            ret.setHandler((Handler)context);
            ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
            holderPwd.setInitOrder(1);
            context.addServlet(holderPwd, "/");
            ServletHolder jerseyServlet = context.addServlet(ServletContainer.class, "/api/v1/*");
            jerseyServlet.setInitOrder(2);
            jerseyServlet.setInitParameter("jakarta.ws.rs.Application", LogviewerApplication.class.getName());
            UIHelpers.configFilters(context, filterConfigurations);
        }
        return ret;
    }

    public LogviewerServer(Map<String, Object> conf, StormMetricsRegistry metricsRegistry) {
        this.httpServer = LogviewerServer.mkHttpServer(metricsRegistry, conf);
        this.meterShutdownCalls = metricsRegistry.registerMeter("logviewer:num-shutdown-calls");
        ExceptionMeterNames.registerMeters(metricsRegistry);
    }

    @VisibleForTesting
    void start() throws Exception {
        LOG.info("Starting Logviewer...");
        if (this.httpServer != null) {
            this.httpServer.start();
        }
    }

    @VisibleForTesting
    void awaitTermination() throws InterruptedException {
        this.httpServer.join();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public static void main(String[] args) throws Exception {
        Utils.setupDefaultUncaughtExceptionHandler();
        Map conf = ConfigUtils.readStormConfig();
        StormMetricsRegistry metricsRegistry = new StormMetricsRegistry();
        String logRoot = ConfigUtils.workerArtifactsRoot((Map)conf);
        File logRootDir = new File(logRoot);
        logRootDir.mkdirs();
        WorkerLogs workerLogs = new WorkerLogs(conf, logRootDir.toPath(), metricsRegistry);
        DirectoryCleaner directoryCleaner = new DirectoryCleaner(metricsRegistry);
        try (LogviewerServer server = new LogviewerServer(conf, metricsRegistry);
             LogCleaner logCleaner = new LogCleaner(conf, workerLogs, directoryCleaner, logRootDir.toPath(), metricsRegistry);){
            metricsRegistry.startMetricsReporters(conf);
            Utils.addShutdownHookWithForceKillIn1Sec(() -> {
                server.meterShutdownCalls.mark();
                metricsRegistry.stopMetricsReporters();
                server.close();
            });
            logCleaner.start();
            server.start();
            server.awaitTermination();
        }
    }
}

