/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.utils;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.storm.daemon.logviewer.utils.LogviewerResponseBuilder;
import org.apache.storm.daemon.logviewer.utils.ResourceAuthorizer;
import org.apache.storm.metric.StormMetricsRegistry;

public class LogFileDownloader {
    private final Histogram fileDownloadSizeDistMb;
    private final Meter numFileDownloadExceptions;
    private final Path logRoot;
    private final Path daemonLogRoot;
    private final ResourceAuthorizer resourceAuthorizer;

    public LogFileDownloader(String logRoot, String daemonLogRoot, ResourceAuthorizer resourceAuthorizer, StormMetricsRegistry metricsRegistry) {
        this.logRoot = Paths.get(logRoot, new String[0]).toAbsolutePath().normalize();
        this.daemonLogRoot = Paths.get(daemonLogRoot, new String[0]).toAbsolutePath().normalize();
        this.resourceAuthorizer = resourceAuthorizer;
        this.fileDownloadSizeDistMb = metricsRegistry.registerHistogram("logviewer:download-file-size-rounded-MB");
        this.numFileDownloadExceptions = metricsRegistry.registerMeter("logviewer:num-file-download-exceptions");
    }

    public Response downloadFile(String host, String fileName, String user, boolean isDaemon) throws IOException {
        Path rootDir = isDaemon ? this.daemonLogRoot : this.logRoot;
        Path rawFile = rootDir.resolve(fileName);
        Path file = rawFile.toAbsolutePath().normalize();
        if (!file.startsWith(rootDir) || !rawFile.normalize().toString().equals(rawFile.toString())) {
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        if (isDaemon && Paths.get(fileName, new String[0]).getNameCount() != 1) {
            return LogviewerResponseBuilder.buildResponsePageNotFound();
        }
        if (file.toFile().exists()) {
            if (isDaemon || this.resourceAuthorizer.isUserAllowedToAccessFile(user, fileName)) {
                this.fileDownloadSizeDistMb.update(Math.round((double)file.toFile().length() / 1048576.0));
                Path pathRelativeToRootDir = rootDir.relativize(file);
                String downloadedFileName = isDaemon || pathRelativeToRootDir.getNameCount() != 3 ? host + "-" + String.valueOf(rawFile.getFileName()) : host + "-" + String.valueOf(pathRelativeToRootDir.getName(0)) + "-" + String.valueOf(pathRelativeToRootDir.getName(1)) + "-" + String.valueOf(pathRelativeToRootDir.getName(2));
                return LogviewerResponseBuilder.buildDownloadFile(downloadedFileName, file.toFile(), this.numFileDownloadExceptions);
            }
            return LogviewerResponseBuilder.buildResponseUnauthorizedUser(user);
        }
        return LogviewerResponseBuilder.buildResponsePageNotFound();
    }
}

