/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.ui;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.daemon.drpc.webapp.ReqContextFilter;
import org.apache.storm.daemon.ui.FilterConfiguration;
import org.apache.storm.daemon.ui.UIHelpers;
import org.apache.storm.daemon.ui.exceptionmappers.AuthorizationExceptionMapper;
import org.apache.storm.daemon.ui.exceptionmappers.DefaultExceptionMapper;
import org.apache.storm.daemon.ui.exceptionmappers.NotAliveExceptionMapper;
import org.apache.storm.daemon.ui.filters.AuthorizedUserFilter;
import org.apache.storm.daemon.ui.filters.HeaderResponseFilter;
import org.apache.storm.daemon.ui.filters.HeaderResponseServletFilter;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.ServerAuthUtils;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIServer {
    public static final Logger LOG = LoggerFactory.getLogger(UIServer.class);
    public static final String STORM_API_URL_PREFIX = "/api/v1/";

    public static void addRequestContextFilter(ServletContextHandler context, String configName, Map<String, Object> conf) {
        IHttpCredentialsPlugin auth = ServerAuthUtils.getHttpCredentialsPlugin(conf, (String)((String)conf.get(configName)));
        ReqContextFilter filter = new ReqContextFilter(auth);
        context.addFilter(new FilterHolder((Filter)filter), "/*", EnumSet.allOf(DispatcherType.class));
    }

    public static void main(String[] args) {
        Map conf = ConfigUtils.readStormConfig();
        int headerBufferSize = (Integer)conf.get("ui.header.buffer.bytes");
        Integer httpsPort = ObjectReader.getInt(conf.get("ui.https.port"), (Integer)0);
        String httpsKsPath = (String)conf.get("ui.https.keystore.path");
        String httpsKsPassword = (String)conf.get("ui.https.keystore.password");
        String httpsKsType = (String)conf.get("ui.https.keystore.type");
        String httpsKeyPassword = (String)conf.get("ui.https.key.password");
        String httpsTsPath = (String)conf.get("ui.https.truststore.path");
        String httpsTsPassword = (String)conf.get("ui.https.truststore.password");
        String httpsTsType = (String)conf.get("ui.https.truststore.type");
        Boolean httpsWantClientAuth = (Boolean)conf.get("ui.https.want.client.auth");
        Boolean httpsNeedClientAuth = (Boolean)conf.get("ui.https.need.client.auth");
        Boolean disableHttpBinding = (Boolean)conf.get("ui.disable.http.binding");
        boolean enableSslReload = ObjectReader.getBoolean(conf.get("ui.https.enable.ssl.reload"), (boolean)false);
        Server jettyServer = UIHelpers.jettyCreateServer((int)((Integer)conf.get("ui.port")), null, httpsPort, headerBufferSize, disableHttpBinding);
        UIHelpers.configSsl(jettyServer, httpsPort, httpsKsPath, httpsKsPassword, httpsKsType, httpsKeyPassword, httpsTsPath, httpsTsPassword, httpsTsType, httpsNeedClientAuth, httpsWantClientAuth, enableSslReload);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        jettyServer.setHandler((Handler)context);
        FilterConfiguration filterConfiguration = new FilterConfiguration((String)conf.get("ui.filter"), (Map)conf.get("ui.filter.params"));
        List<FilterConfiguration> filterConfigurationList = Arrays.asList(filterConfiguration);
        UIHelpers.configFilters(context, filterConfigurationList);
        final StormMetricsRegistry metricsRegistry = new StormMetricsRegistry();
        ResourceConfig resourceConfig = new ResourceConfig().packages(new String[]{"org.apache.storm.daemon.ui.resources"}).registerInstances(new Object[]{new AbstractBinder(){

            protected void configure() {
                super.bind((Object)metricsRegistry).to(StormMetricsRegistry.class);
            }
        }}).register(AuthorizedUserFilter.class).register(HeaderResponseFilter.class).register(AuthorizationExceptionMapper.class).register(NotAliveExceptionMapper.class).register(DefaultExceptionMapper.class);
        ServletHolder jerseyServlet = new ServletHolder((Servlet)new ServletContainer(resourceConfig));
        jerseyServlet.setInitOrder(0);
        context.addServlet(jerseyServlet, "/api/v1/*");
        UIServer.addRequestContextFilter(context, "ui.http.creds.plugin", conf);
        ServletHolder holderHome = new ServletHolder("static-home", DefaultServlet.class);
        String packagedStaticFileLocation = System.getProperty("storm.home") + ConfigUtils.FILE_SEPARATOR + "public/";
        if (Files.exists(Paths.get(packagedStaticFileLocation, new String[0]), new LinkOption[0])) {
            holderHome.setInitParameter("resourceBase", packagedStaticFileLocation);
        } else {
            LOG.warn("Cannot find static file directory in " + packagedStaticFileLocation + " - assuming that UIServer is being launchedin a development environment and not from a packaged release");
            String developmentStaticFileLocation = UIServer.class.getProtectionDomain().getCodeSource().getLocation().getPath() + "WEB-INF";
            if (Files.exists(Paths.get(developmentStaticFileLocation, new String[0]), new LinkOption[0])) {
                holderHome.setInitParameter("resourceBase", developmentStaticFileLocation);
            } else {
                throw new RuntimeException("Cannot find static file directory in development location " + developmentStaticFileLocation);
            }
        }
        holderHome.setInitParameter("dirAllowed", "true");
        holderHome.setInitParameter("pathInfoOnly", "true");
        context.addFilter(new FilterHolder((Filter)new HeaderResponseServletFilter(metricsRegistry)), "/*", EnumSet.allOf(DispatcherType.class));
        context.addServlet(holderHome, "/*");
        ServletHolder holderPwd = new ServletHolder("default", DefaultServlet.class);
        holderPwd.setInitParameter("dirAllowed", "true");
        context.addServlet(holderPwd, "/");
        metricsRegistry.startMetricsReporters(conf);
        Utils.addShutdownHookWithForceKillIn1Sec(() -> ((StormMetricsRegistry)metricsRegistry).stopMetricsReporters());
        try {
            jettyServer.start();
            jettyServer.join();
        }
        catch (Throwable t) {
            LOG.error("Exception in UIServer: ", t);
            throw new RuntimeException(t);
        }
    }
}

