/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.CyclicDefinitionException;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;

public class IdentifierNamespace
extends AbstractNamespace {
    private final SqlIdentifier id;
    private final SqlValidatorScope parentScope;
    public final SqlNodeList extendList;
    private SqlValidatorNamespace resolvedNamespace;
    private List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs;

    IdentifierNamespace(SqlValidatorImpl validator, SqlIdentifier id, @Nullable SqlNodeList extendList, SqlNode enclosingNode, SqlValidatorScope parentScope) {
        super(validator, enclosingNode);
        this.id = id;
        this.extendList = extendList;
        this.parentScope = (SqlValidatorScope)Preconditions.checkNotNull((Object)parentScope);
    }

    IdentifierNamespace(SqlValidatorImpl validator, SqlNode node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
        this(validator, (SqlIdentifier)IdentifierNamespace.split((SqlNode)node).left, (SqlNodeList)IdentifierNamespace.split((SqlNode)node).right, enclosingNode, parentScope);
    }

    protected static Pair<SqlIdentifier, SqlNodeList> split(SqlNode node) {
        switch (node.getKind()) {
            case EXTEND: {
                SqlCall call = (SqlCall)node;
                return Pair.of((SqlIdentifier)call.getOperandList().get(0), (SqlNodeList)call.getOperandList().get(1));
            }
        }
        return Pair.of((SqlIdentifier)node, null);
    }

    private SqlValidatorNamespace resolveImpl(SqlIdentifier id) {
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        List<String> names = SqlIdentifier.toStar(id.names);
        try {
            this.parentScope.resolveTable(names, nameMatcher, SqlValidatorScope.Path.EMPTY, resolved);
        }
        catch (CyclicDefinitionException e) {
            if (e.depth == 1) {
                throw this.validator.newValidationError(id, Static.RESOURCE.cyclicDefinition(id.toString(), SqlIdentifier.getString(e.path)));
            }
            throw new CyclicDefinitionException(e.depth - 1, e.path);
        }
        SqlValidatorScope.Resolve previousResolve = null;
        if (resolved.count() == 1) {
            SqlValidatorScope.Resolve resolve = previousResolve = resolved.only();
            if (resolve.remainingNames.isEmpty()) {
                return resolve.namespace;
            }
            if (!nameMatcher.isCaseSensitive()) {
                throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundWithin(resolve.remainingNames.get(0), SqlIdentifier.getString(resolve.path.stepNames())));
            }
        }
        if (nameMatcher.isCaseSensitive()) {
            SqlNameMatcher liberalMatcher = SqlNameMatchers.liberal();
            resolved.clear();
            this.parentScope.resolveTable(names, liberalMatcher, SqlValidatorScope.Path.EMPTY, resolved);
            if (resolved.count() == 1) {
                SqlValidatorScope.Resolve resolve = resolved.only();
                if (resolve.remainingNames.isEmpty() || previousResolve == null) {
                    int i = previousResolve == null ? 0 : previousResolve.path.stepCount();
                    int offset = resolve.path.stepCount() + resolve.remainingNames.size() - names.size();
                    List<String> prefix = resolve.path.stepNames().subList(0, offset + i);
                    String next = resolve.path.stepNames().get(i + offset);
                    if (prefix.isEmpty()) {
                        throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundDidYouMean(names.get(i), next));
                    }
                    throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundWithinDidYouMean(names.get(i), SqlIdentifier.getString(prefix), next));
                }
                throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFoundWithin(resolve.remainingNames.get(0), SqlIdentifier.getString(resolve.path.stepNames())));
            }
        }
        throw this.validator.newValidationError(id, Static.RESOURCE.objectNotFound(id.getComponent(0).toString()));
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.resolvedNamespace = (SqlValidatorNamespace)Preconditions.checkNotNull((Object)this.resolveImpl(this.id));
        if (this.resolvedNamespace instanceof TableNamespace) {
            List<String> qualifiedNames;
            SqlValidatorTable table = this.resolvedNamespace.getTable();
            if (this.validator.shouldExpandIdentifiers() && (qualifiedNames = table.getQualifiedName()) != null) {
                ArrayList<SqlParserPos> poses = new ArrayList<SqlParserPos>(Collections.nCopies(qualifiedNames.size(), this.id.getParserPosition()));
                int offset = qualifiedNames.size() - this.id.names.size();
                if (offset >= 0) {
                    for (int i = 0; i < this.id.names.size(); ++i) {
                        poses.set(i + offset, this.id.getComponentParserPosition(i));
                    }
                }
                this.id.setNames(qualifiedNames, poses);
            }
        }
        RelDataType rowType = this.resolvedNamespace.getRowType();
        if (this.extendList != null) {
            if (!(this.resolvedNamespace instanceof TableNamespace)) {
                throw new RuntimeException("cannot convert");
            }
            this.resolvedNamespace = ((TableNamespace)this.resolvedNamespace).extend(this.extendList);
            rowType = this.resolvedNamespace.getRowType();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RelDataTypeField> fields = rowType.getFieldList();
        for (RelDataTypeField field : fields) {
            String fieldName = field.getName();
            SqlMonotonicity monotonicity = this.resolvedNamespace.getMonotonicity(fieldName);
            if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            builder.add(Pair.of(new SqlIdentifier(fieldName, SqlParserPos.ZERO), monotonicity));
        }
        this.monotonicExprs = builder.build();
        return rowType;
    }

    public SqlIdentifier getId() {
        return this.id;
    }

    @Override
    public SqlNode getNode() {
        return this.id;
    }

    @Override
    public SqlValidatorNamespace resolve() {
        assert (this.resolvedNamespace != null) : "must call validate first";
        return this.resolvedNamespace.resolve();
    }

    @Override
    public SqlValidatorTable getTable() {
        return this.resolvedNamespace == null ? null : this.resolve().getTable();
    }

    @Override
    public List<Pair<SqlNode, SqlMonotonicity>> getMonotonicExprs() {
        return this.monotonicExprs;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlValidatorTable table = this.getTable();
        return table.getMonotonicity(columnName);
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        SqlValidatorTable table = this.getTable();
        if (table == null) {
            return modality == SqlModality.RELATION;
        }
        return table.supportsModality(modality);
    }
}

