/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.streams.functions;

import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.StormContext;
import org.apache.storm.sql.runtime.calcite.DebuggableExecutableExpression;
import org.apache.storm.sql.runtime.calcite.ExecutableExpression;
import org.apache.storm.streams.operations.Predicate;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationFilter
implements Predicate<Values> {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationFilter.class);
    private final ExecutableExpression filterInstance;
    private final DataContext dataContext;
    private final Object[] outputValues;

    public EvaluationFilter(ExecutableExpression filterInstance, DataContext dataContext) {
        this.filterInstance = filterInstance;
        this.dataContext = dataContext;
        this.outputValues = new Object[1];
        if (filterInstance != null && filterInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code for filter: \n{}", (Object)((DebuggableExecutableExpression)filterInstance).getDelegateCode());
        }
    }

    public boolean test(Values input) {
        StormContext calciteContext = new StormContext(this.dataContext);
        calciteContext.values = input.toArray();
        this.filterInstance.execute(calciteContext, this.outputValues);
        return this.outputValues[0] != null && (Boolean)this.outputValues[0] != false;
    }
}

