/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.imps;

import org.apache.storm.shade.org.apache.curator.drivers.OperationTrace;
import org.apache.storm.shade.org.apache.curator.framework.api.CuratorEventType;
import org.apache.storm.shade.org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.storm.shade.org.apache.curator.framework.imps.CuratorFrameworkBase;
import org.apache.storm.shade.org.apache.curator.framework.imps.OperationAndData;
import org.apache.storm.shade.org.apache.zookeeper.AsyncCallback;

class BackgroundSyncImpl
implements BackgroundOperation<String> {
    private final CuratorFrameworkBase client;
    private final Object context;

    BackgroundSyncImpl(CuratorFrameworkBase client, Object context) {
        this.client = client;
        this.context = context;
    }

    @Override
    public CuratorEventType getBackgroundEventType() {
        return CuratorEventType.SYNC;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("BackgroundSyncImpl");
        final String data = operationAndData.getData();
        this.client.getZooKeeper().sync(data, new AsyncCallback.VoidCallback(){
            final /* synthetic */ BackgroundSyncImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void processResult(int rc, String path, Object ctx) {
                trace.setReturnCode(rc).setRequestBytesLength(data).commit();
                CuratorEventImpl event = new CuratorEventImpl(this.this$0.client, CuratorEventType.SYNC, rc, path, null, ctx, null, null, null, null, null, null);
                this.this$0.client.processBackgroundOperation(operationAndData, event);
            }
        }, this.context);
    }
}

