/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.generate;

import java.util.Iterator;
import java.util.Map;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.VertexFactory;
import org.apache.storm.shade.org.jgrapht.generate.GraphGenerator;

public class CompleteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int size;

    public CompleteGraphGenerator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.size = size;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        if (this.size < 1) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            V newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
        }
        for (V latestVertex : target.vertexSet()) {
            Iterator<V> fastI = target.vertexSet().iterator();
            while (fastI.next() != latestVertex) {
            }
            while (fastI.hasNext()) {
                V temp = fastI.next();
                target.addEdge(latestVertex, temp);
                target.addEdge(temp, latestVertex);
            }
        }
    }
}

