/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.lib.CLALibCombineGroups;

public class ComEstCompressed
extends AComEst {
    final CompressedMatrixBlock cData;

    protected ComEstCompressed(CompressedMatrixBlock data, CompressionSettings compSettings) {
        super(data, compSettings);
        this.cData = data;
    }

    @Override
    protected List<CompressedSizeInfoColGroup> CompressedSizeInfoColGroup(int clen, int k) {
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        int nRow = this.cData.getNumRows();
        for (AColGroup g : this.cData.getColGroups()) {
            ret.add(g.getCompressionInfo(nRow));
        }
        return ret;
    }

    @Override
    public CompressedSizeInfoColGroup getColGroupInfo(IColIndex colIndexes, int estimate, int nrUniqueUpperBound) {
        return null;
    }

    @Override
    public CompressedSizeInfoColGroup getDeltaColGroupInfo(IColIndex colIndexes, int estimate, int nrUniqueUpperBound) {
        return null;
    }

    @Override
    protected int worstCaseUpperBound(IColIndex columns) {
        if (columns.size() == 1) {
            int id = columns.get(0);
            AColGroup g = this.cData.getColGroupForColumn(id);
            return g.getNumValues();
        }
        List<AColGroup> groups = CLALibCombineGroups.findGroupsInIndex(columns, this.cData.getColGroups());
        long nVals = 1L;
        for (AColGroup g : groups) {
            nVals *= (long)g.getNumValues();
        }
        return Math.min(this._data.getNumRows(), (int)Math.min(nVals, Integer.MAX_VALUE));
    }

    @Override
    protected CompressedSizeInfoColGroup combine(IColIndex combinedColumns, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2, int maxDistinct) {
        IEncode map = g1.getMap().combine(g2.getMap());
        return this.getFacts(map, combinedColumns);
    }

    protected CompressedSizeInfoColGroup getFacts(IEncode map, IColIndex colIndexes) {
        int _numRows = this.getNumRows();
        EstimationFactors em = map.extractFacts(_numRows, this._data.getSparsity(), this._data.getSparsity(), this._cs);
        return new CompressedSizeInfoColGroup(colIndexes, em, this._cs.validCompressions, map);
    }
}

