/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.LibCommonsMath;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class MultiReturnComplexMatrixBuiltinCPInstruction
extends ComputationCPInstruction {
    protected final ArrayList<CPOperand> _outputs;
    protected final int _numThreads;

    private MultiReturnComplexMatrixBuiltinCPInstruction(Operator op, CPOperand input1, CPOperand input2, ArrayList<CPOperand> outputs, String opcode, String istr, int threads) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, input2, outputs.get(0), opcode, istr);
        this._outputs = outputs;
        this._numThreads = threads;
    }

    private MultiReturnComplexMatrixBuiltinCPInstruction(Operator op, CPOperand input1, ArrayList<CPOperand> outputs, String opcode, String istr, int threads) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, null, outputs.get(0), opcode, istr);
        this._outputs = outputs;
        this._numThreads = threads;
    }

    private MultiReturnComplexMatrixBuiltinCPInstruction(Operator op, CPOperand input1, CPOperand input2, CPOperand input3, CPOperand input4, ArrayList<CPOperand> outputs, String opcode, String istr, int threads) {
        super(CPInstruction.CPType.MultiReturnBuiltin, op, input1, input2, input3, input4, outputs.get(0), opcode, istr);
        this._outputs = outputs;
        this._numThreads = threads;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public List<CPOperand> getOutputs() {
        return this._outputs;
    }

    public String[] getOutputNames() {
        return (String[])this._outputs.parallelStream().map(output -> output.getName()).toArray(String[]::new);
    }

    public static MultiReturnComplexMatrixBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (parts.length == 6 && opcode.equalsIgnoreCase(Opcodes.IFFT.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[5]);
            return new MultiReturnComplexMatrixBuiltinCPInstruction(null, in1, in2, outputs, opcode, str, threads);
        }
        if (parts.length == 5 && opcode.equalsIgnoreCase(Opcodes.IFFT.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[4]);
            return new MultiReturnComplexMatrixBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        if (parts.length == 6 && opcode.equalsIgnoreCase(Opcodes.IFFT_LINEARIZED.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[5]);
            return new MultiReturnComplexMatrixBuiltinCPInstruction(null, in1, in2, outputs, opcode, str, threads);
        }
        if (parts.length == 5 && opcode.equalsIgnoreCase(Opcodes.IFFT_LINEARIZED.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[4]);
            return new MultiReturnComplexMatrixBuiltinCPInstruction(null, in1, outputs, opcode, str, threads);
        }
        if (parts.length == 7 && opcode.equalsIgnoreCase(Opcodes.STFT.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand windowSize = new CPOperand(parts[2]);
            CPOperand overlap = new CPOperand(parts[3]);
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[5], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[6]);
            return new MultiReturnComplexMatrixBuiltinCPInstruction(null, in1, null, windowSize, overlap, outputs, opcode, str, threads);
        }
        if (parts.length == 8 && opcode.equalsIgnoreCase(Opcodes.STFT.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand windowSize = new CPOperand(parts[3]);
            CPOperand overlap = new CPOperand(parts[4]);
            outputs.add(new CPOperand(parts[5], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[6], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[7]);
            return new MultiReturnComplexMatrixBuiltinCPInstruction(null, in1, in2, windowSize, overlap, outputs, opcode, str, threads);
        }
        if (opcode.equalsIgnoreCase(Opcodes.RCM.toString())) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            outputs.add(new CPOperand(parts[3], Types.ValueType.FP64, Types.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Types.ValueType.FP64, Types.DataType.MATRIX));
            int threads = Integer.parseInt(parts[5]);
            return new MultiReturnComplexMatrixBuiltinCPInstruction(null, in1, in2, outputs, opcode, str, threads);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    public int getNumOutputs() {
        return this._outputs.size();
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (this.getOpcode().equals(Opcodes.STFT.toString()) && this.input2 == null) {
            this.processSTFTInstruction(ec);
        } else if (this.getOpcode().equals(Opcodes.STFT.toString())) {
            this.processSTFTTwoInstruction(ec);
        } else if (this.input2 == null) {
            this.processOneInputInstruction(ec);
        } else {
            this.processTwoInputInstruction(ec);
        }
    }

    private void processOneInputInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in = ec.getMatrixInput(this.input1.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in, this.getOpcode(), this._numThreads);
        ec.releaseMatrixInput(this.input1.getName());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }

    private void processTwoInputInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock in2 = ec.getMatrixInput(this.input2.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in1, in2, this.getOpcode());
        ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }

    private void processSTFTInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in1 = ec.getMatrixInput(this.input1.getName());
        int windowSize = Integer.parseInt(this.input3.getName());
        int overlap = Integer.parseInt(this.input4.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in1, this.getOpcode(), windowSize, overlap);
        ec.releaseMatrixInput(this.input1.getName());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }

    private void processSTFTTwoInstruction(ExecutionContext ec) {
        if (!LibCommonsMath.isSupportedMultiReturnOperation(this.getOpcode())) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + this.getOpcode());
        }
        MatrixBlock in1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock in2 = ec.getMatrixInput(this.input2.getName());
        int windowSize = Integer.parseInt(this.input3.getName());
        int overlap = Integer.parseInt(this.input4.getName());
        MatrixBlock[] out = LibCommonsMath.multiReturnOperations(in1, in2, this.getOpcode(), windowSize, overlap);
        ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }

    @Override
    public boolean hasSingleLineage() {
        return false;
    }

    @Override
    public Pair<String, LineageItem>[] getLineageItems(ExecutionContext ec) {
        LineageItem[] inputLineage = LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3);
        Pair[] ret = new Pair[this._outputs.size()];
        for (int i = 0; i < this._outputs.size(); ++i) {
            CPOperand out = this._outputs.get(i);
            ret[i] = Pair.of((Object)out.getName(), (Object)new LineageItem(this.getOpcode(), inputLineage));
        }
        return ret;
    }
}

