/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class CommonThreadPool
implements ExecutorService {
    protected static final Log LOG = LogFactory.getLog((String)CommonThreadPool.class.getName());
    private static final int size = InfrastructureAnalyzer.getLocalParallelism();
    private static final ExecutorService shared = ForkJoinPool.commonPool();
    private static ConcurrentHashMap<Long, CommonThreadPool> shared2 = null;
    private static ExecutorService asyncPool = null;
    private final ExecutorService _pool;
    public static boolean incorrectPoolUse = false;

    public CommonThreadPool(ExecutorService pool) {
        this._pool = pool;
    }

    public static ExecutorService get() {
        return shared;
    }

    public static synchronized ExecutorService get(int k) {
        if (k <= 1) {
            LOG.warn((Object)"Invalid to create thread pool with <= one thread returning single thread executor", (Throwable)new RuntimeException());
            return new SameThreadExecutorService();
        }
        Thread thisThread = Thread.currentThread();
        String threadName = thisThread.getName();
        boolean mainThread = threadName.contains("main");
        if (size == k && mainThread) {
            return shared;
        }
        if (mainThread || threadName.contains("PARFOR") || threadName.contains("FedExec")) {
            CommonThreadPool pool;
            if (shared2 == null) {
                shared2 = new ConcurrentHashMap();
            }
            if ((pool = shared2.get(thisThread.getId())) == null) {
                pool = new CommonThreadPool(new ForkJoinPool(k));
                shared2.put(thisThread.getId(), pool);
            }
            return pool;
        }
        if (!incorrectPoolUse) {
            if (threadName.contains("test")) {
                LOG.error((Object)"Thread from test is not correctly using pools, please modify thread name to contain 'main'", (Throwable)new RuntimeException());
            } else {
                LOG.warn((Object)"An instruction allocated it's own thread pool indicating that some task is not properly reusing the threads.", (Throwable)new RuntimeException());
            }
            incorrectPoolUse = true;
        }
        return Executors.newFixedThreadPool(k);
    }

    public static <T> void invokeAndShutdown(ExecutorService pool, Collection<? extends Callable<T>> tasks) {
        try {
            List ret = pool.invokeAll(tasks);
            for (Future r : ret) {
                r.get();
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        finally {
            pool.shutdown();
        }
    }

    public static synchronized ExecutorService getDynamicPool() {
        if (asyncPool != null) {
            return asyncPool;
        }
        asyncPool = Executors.newCachedThreadPool();
        return asyncPool;
    }

    public static synchronized void shutdownAsyncPools() {
        if (asyncPool != null) {
            asyncPool.shutdown();
            asyncPool = null;
        }
        if (shared2 != null) {
            for (Long e : shared2.keySet()) {
                CommonThreadPool.shutdownPool(e);
            }
            shared2 = null;
        }
    }

    public static synchronized void shutdownAsyncPools(Thread thread) {
        if (shared2 != null) {
            CommonThreadPool.shutdownPool(thread.getId());
        }
    }

    private static void shutdownPool(long id) {
        CommonThreadPool p = shared2.get(id);
        if (p != null) {
            p._pool.shutdownNow();
            shared2.remove(id);
        }
    }

    public static synchronized boolean generalCached() {
        return shared2 != null && shared2.get(Thread.currentThread().getId()) != null;
    }

    public final boolean isCached() {
        return this._pool.equals(shared) || CommonThreadPool.generalCached();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isCached()) {
            this._pool.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return !this.isCached() ? this._pool.shutdownNow() : null;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this._pool.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this._pool.invokeAll(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this._pool.execute(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this._pool.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this._pool.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this._pool.submit(task);
    }

    @Override
    public boolean isShutdown() {
        return this.isCached() || this._pool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.isCached() || this._pool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.isCached() || this._pool.awaitTermination(timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this._pool.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this._pool.invokeAny(tasks);
    }

    public static boolean useParallelismOnThread() {
        Thread t = Thread.currentThread();
        String name = t.getName();
        if (name.equals("main")) {
            return true;
        }
        if (name.contains("PARFOR")) {
            return true;
        }
        return name.contains("test");
    }

    public static class SameThreadExecutorService
    implements ExecutorService {
        private SameThreadExecutorService() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return new ArrayList<Runnable>();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return new NonFuture<T>(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return new NonFuture<Object>(() -> {
                task.run();
                return result;
            });
        }

        @Override
        public Future<?> submit(Runnable task) {
            return new NonFuture<Object>(() -> {
                task.run();
                return null;
            });
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            ArrayList<Future<T>> ret = new ArrayList<Future<T>>();
            for (Callable<T> t : tasks) {
                ret.add(new NonFuture<T>(t));
            }
            return ret;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.invokeAll(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            Exception e = null;
            for (Callable<T> t : tasks) {
                try {
                    T r = t.call();
                    return r;
                }
                catch (Exception ee) {
                    e = ee;
                }
            }
            throw new ExecutionException("failed", e);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Exception e = null;
            for (Callable<T> t : tasks) {
                try {
                    T r = t.call();
                    return r;
                }
                catch (Exception ee) {
                    e = ee;
                }
            }
            throw new ExecutionException("failed", e);
        }

        private static class NonFuture<V>
        implements Future<V> {
            V r;

            protected NonFuture(Callable<V> c) {
                try {
                    this.r = c.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                return this.r;
            }

            @Override
            public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.r;
            }
        }
    }
}

