/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.cost;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.lops.PickByCount;
import org.apache.sysds.resource.cost.IOCostUtils;
import org.apache.sysds.resource.cost.VarStats;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CentralMomentCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CovarianceCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DnnCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuantilePickCPInstruction;
import org.apache.sysds.runtime.instructions.cp.QuantileSortCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysds.runtime.instructions.cp.StringInitCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UaggOuterChainCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class CPCostUtils {
    private static final long DEFAULT_NFLOP_NOOP = 10L;
    private static final long DEFAULT_NFLOP_CP = 1L;
    private static final long DEFAULT_NFLOP_TEXT_IO = 350L;
    private static final long DEFAULT_INFERRED_DIM = 1000000L;

    public static double getVariableInstTime(VariableCPInstruction inst, VarStats input, VarStats output, IOCostUtils.IOMetrics metrics) {
        long nflop;
        switch (inst.getOpcode()) {
            case "write": {
                String fmtStr = inst.getInput3().getLiteral().getStringValue();
                Types.FileFormat fmt = Types.FileFormat.safeValueOf(fmtStr);
                long xwrite = fmt.isTextFormat() ? 350L : 1L;
                nflop = input.getCellsWithSparsity() * xwrite;
                break;
            }
            case "cast_as_matrix": 
            case "cast_as_frame": {
                nflop = input.getCells();
                break;
            }
            case "rmfilevar": 
            case "attachfiletovar": 
            case "setfilename": {
                throw new RuntimeException("Undefined behaviour for instruction with opcode: " + inst.getOpcode());
            }
            default: {
                return 0.0;
            }
        }
        return CPCostUtils.getCPUTime(nflop, metrics, output, input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getDataGenCPInstTime(UnaryCPInstruction inst, VarStats output, IOCostUtils.IOMetrics metrics) {
        long nflop;
        String opcode = inst.getOpcode();
        if (inst instanceof DataGenCPInstruction) {
            if (opcode.equals("rand") || opcode.equals("frame")) {
                DataGenCPInstruction rinst = (DataGenCPInstruction)inst;
                nflop = rinst.getMinValue() == 0.0 && rinst.getMaxValue() == 0.0 ? 0L : (rinst.getSparsity() == 1.0 && rinst.getMinValue() == rinst.getMaxValue() ? 8L * output.getCells() : (rinst.getSparsity() == 1.0 ? 32L * output.getCells() + 8L * output.getCells() : (rinst.getSparsity() < 0.4 ? 3L * output.getCellsWithSparsity() + 24L * output.getCellsWithSparsity() : 2L * output.getCells() + 8L * output.getCells())));
                return CPCostUtils.getCPUTime(nflop, metrics, output, new VarStats[0]);
            } else {
                if (!opcode.equals(Opcodes.SEQUENCE.toString())) throw new RuntimeException("Undefined behaviour for instruction with opcode: " + inst.getOpcode());
                nflop = 1L * output.getCells();
            }
            return CPCostUtils.getCPUTime(nflop, metrics, output, new VarStats[0]);
        } else {
            if (!(inst instanceof StringInitCPInstruction)) throw new IllegalArgumentException("Method has been called with invalid instruction: " + inst);
            nflop = 1L * output.getCells();
        }
        return CPCostUtils.getCPUTime(nflop, metrics, output, new VarStats[0]);
    }

    public static double getUnaryInstTime(UnaryCPInstruction inst, VarStats input, VarStats weights, VarStats output, IOCostUtils.IOMetrics metrics) {
        if (inst instanceof UaggOuterChainCPInstruction || inst instanceof DnnCPInstruction) {
            throw new RuntimeException("Time estimation for CP instruction of class " + inst.getClass().getName() + "not supported yet");
        }
        CPInstruction.CPType instructionType = inst.getCPInstructionType();
        Object opcode = inst.getOpcode();
        boolean includeWeights = false;
        if (inst instanceof MMTSJCPInstruction) {
            MMTSJ.MMTSJType type = ((MMTSJCPInstruction)inst).getMMTSJType();
            opcode = (String)opcode + (type.isLeft() ? "_left" : "_right");
        } else if (inst instanceof ReorgCPInstruction && ((String)opcode).equals(Opcodes.SORT.toString())) {
            if (inst.input2 != null) {
                includeWeights = true;
            }
        } else if (inst instanceof QuantileSortCPInstruction) {
            if (inst.input2 != null) {
                opcode = (String)opcode + "_wts";
                includeWeights = true;
            }
        } else if (inst instanceof CentralMomentCPInstruction) {
            CMOperator.AggregateOperationTypes opType = ((CMOperator)inst.getOperator()).getAggOpType();
            opcode = (String)opcode + "_" + opType.name().toLowerCase();
            if (inst.input2 != null) {
                includeWeights = true;
            }
        }
        long nflop = CPCostUtils.getInstNFLOP(instructionType, (String)opcode, output, input);
        if (includeWeights) {
            return CPCostUtils.getCPUTime(nflop, metrics, output, input, weights);
        }
        if (!CPCostUtils.opcodeRequiresScan((String)opcode)) {
            return CPCostUtils.getCPUTime(nflop, metrics, output, new VarStats[0]);
        }
        return CPCostUtils.getCPUTime(nflop, metrics, output, input);
    }

    public static double getBinaryInstTime(BinaryCPInstruction inst, VarStats input1, VarStats input2, VarStats weights, VarStats output, IOCostUtils.IOMetrics metrics) {
        CPInstruction.CPType instructionType = inst.getCPInstructionType();
        Object opcode = inst.getOpcode();
        boolean includeWeights = false;
        if (inst instanceof CovarianceCPInstruction) {
            includeWeights = true;
        } else if (inst instanceof QuantilePickCPInstruction) {
            PickByCount.OperationTypes opType = ((QuantilePickCPInstruction)inst).getOperationType();
            opcode = (String)opcode + "_" + opType.name().toLowerCase();
        } else if (inst instanceof AggregateBinaryCPInstruction) {
            AggregateBinaryCPInstruction abinst = (AggregateBinaryCPInstruction)inst;
            opcode = (String)opcode + (abinst.transposeLeft ? "_tl" : "");
            opcode = (String)opcode + (abinst.transposeRight ? "_tr" : "");
        }
        long nflop = CPCostUtils.getInstNFLOP(instructionType, (String)opcode, output, input1, input2);
        if (includeWeights) {
            return CPCostUtils.getCPUTime(nflop, metrics, output, input1, input2, weights);
        }
        return CPCostUtils.getCPUTime(nflop, metrics, output, input1, input2);
    }

    public static double getComputationInstTime(ComputationCPInstruction inst, VarStats input1, VarStats input2, VarStats input3, VarStats input4, VarStats output, IOCostUtils.IOMetrics metrics) {
        if (inst instanceof UnaryCPInstruction || inst instanceof BinaryCPInstruction) {
            throw new RuntimeException("Instructions of type UnaryCPInstruction and BinaryCPInstruction are not handled by this method");
        }
        CPInstruction.CPType instructionType = inst.getCPInstructionType();
        String opcode = inst.getOpcode();
        long nflop = CPCostUtils.getInstNFLOP(instructionType, opcode, output, input1, input2);
        return CPCostUtils.getCPUTime(nflop, metrics, output, input1, input2, input3, input4);
    }

    public static double getBuiltinNaryInstTime(BuiltinNaryCPInstruction inst, VarStats[] inputs, VarStats output, IOCostUtils.IOMetrics metrics) {
        CPInstruction.CPType instructionType = inst.getCPInstructionType();
        String opcode = inst.getOpcode();
        if (inputs == null) {
            long nflop = CPCostUtils.getInstNFLOP(instructionType, opcode, output, new VarStats[0]);
            return CPCostUtils.getCPUTime(nflop, metrics, output, new VarStats[0]);
        }
        long nflop = CPCostUtils.getInstNFLOP(instructionType, opcode, output, inputs);
        return CPCostUtils.getCPUTime(nflop, metrics, output, inputs);
    }

    public static double getParameterizedBuiltinInstTime(ParameterizedBuiltinCPInstruction inst, VarStats input, VarStats output, IOCostUtils.IOMetrics metrics) {
        CPInstruction.CPType instructionType = inst.getCPInstructionType();
        Object opcode = inst.getOpcode();
        if (((String)opcode).equals(Opcodes.RMEMPTY.toString())) {
            String margin = inst.getParameterMap().get("margin");
            opcode = (String)opcode + "_" + margin;
        } else if (((String)opcode).equals(Opcodes.GROUPEDAGG.toString())) {
            CMOperator.AggregateOperationTypes opType = ((CMOperator)inst.getOperator()).getAggOpType();
            opcode = (String)opcode + "_" + opType.name().toLowerCase();
        }
        long nflop = CPCostUtils.getInstNFLOP(instructionType, (String)opcode, output, input);
        return CPCostUtils.getCPUTime(nflop, metrics, output, input);
    }

    public static double getMultiReturnBuiltinInstTime(MultiReturnBuiltinCPInstruction inst, VarStats input, VarStats[] outputs, IOCostUtils.IOMetrics metrics) {
        CPInstruction.CPType instructionType = inst.getCPInstructionType();
        String opcode = inst.getOpcode();
        long nflop = CPCostUtils.getInstNFLOP(instructionType, opcode, outputs[0], input);
        double time = CPCostUtils.getCPUTime(nflop, metrics, outputs[0], input);
        for (int i = 1; i < outputs.length; ++i) {
            time += IOCostUtils.getMemWriteTime(outputs[i], metrics);
        }
        return time;
    }

    public static boolean opcodeRequiresScan(String opcode) {
        return !opcode.equals(Opcodes.NCOL.toString()) && !opcode.equals(Opcodes.NROW.toString()) && !opcode.equals(Opcodes.LENGTH.toString()) && !opcode.equals(Opcodes.EXISTS.toString()) && !opcode.equals(Opcodes.LINEAGE.toString());
    }

    public static void assignOutputMemoryStats(CPInstruction inst, VarStats output, VarStats ... inputs) {
        CPInstruction.CPType instType = inst.getCPInstructionType();
        String opcode = inst.getOpcode();
        if (inst instanceof MultiReturnBuiltinCPInstruction) {
            boolean inferred = false;
            for (VarStats current : inputs) {
                if (!inferred && current.getCells() < 0L) {
                    CPCostUtils.inferStats(instType, opcode, output, inputs);
                    inferred = true;
                }
                if (current.getCells() < 0L) {
                    throw new RuntimeException("Operation of type MultiReturnBuiltin with opcode '" + opcode + "' has incomplete formula for inferring dimensions");
                }
                current.allocatedMemory = OptimizerUtils.estimateSizeExactSparsity(current.characteristics);
            }
            return;
        }
        if (output.getCells() < 0L) {
            CPCostUtils.inferStats(instType, opcode, output, inputs);
        }
        output.allocatedMemory = output.isScalar() ? 1L : OptimizerUtils.estimateSizeExactSparsity(output.characteristics);
    }

    public static void inferStats(CPInstruction.CPType instType, String opcode, VarStats output, VarStats ... inputs) {
        switch (instType) {
            case Unary: 
            case Builtin: {
                CPCostUtils.copyMissingDim(output, inputs[0]);
                break;
            }
            case AggregateUnary: {
                if (opcode.startsWith("uar")) {
                    CPCostUtils.copyMissingDim(output, inputs[0].getM(), 1L);
                    break;
                }
                if (opcode.startsWith("uac")) {
                    CPCostUtils.copyMissingDim(output, 1L, inputs[0].getN());
                    break;
                }
                CPCostUtils.copyMissingDim(output, 1L, 1L);
                break;
            }
            case MatrixIndexing: {
                if (opcode.equals("rightIndex")) {
                    long rowRange;
                    long colUpper;
                    long rowLower = inputs[2].varName.matches("\\d+") ? Long.parseLong(inputs[2].varName) : -1L;
                    long rowUpper = inputs[3].varName.matches("\\d+") ? Long.parseLong(inputs[3].varName) : -1L;
                    long colLower = inputs[4].varName.matches("\\d+") ? Long.parseLong(inputs[4].varName) : -1L;
                    long l = colUpper = inputs[5].varName.matches("\\d+") ? Long.parseLong(inputs[5].varName) : -1L;
                    if (rowLower > 0L && rowUpper > 0L) {
                        rowRange = rowUpper - rowLower + 1L;
                    } else if (inputs[2].varName.equals(inputs[3].varName)) {
                        rowRange = 1L;
                    } else {
                        long l2 = rowRange = inputs[0].getM() > 0L ? inputs[0].getM() : 1000000L;
                    }
                    long colRange = colLower > 0L && colUpper > 0L ? colUpper - colLower + 1L : (inputs[4].varName.equals(inputs[5].varName) ? 1L : (inputs[0].getM() > 0L ? inputs[0].getN() : 1000000L));
                    CPCostUtils.copyMissingDim(output, rowRange, colRange);
                    break;
                }
                CPCostUtils.copyMissingDim(output, inputs[0]);
                break;
            }
            case Reorg: {
                switch (opcode) {
                    case "r'": {
                        CPCostUtils.copyMissingDim(output, inputs[0].getN(), inputs[0].getM());
                        break;
                    }
                    case "rev": {
                        CPCostUtils.copyMissingDim(output, inputs[0]);
                        break;
                    }
                    case "rdiag": {
                        if (inputs[0].getN() == 1L) {
                            CPCostUtils.copyMissingDim(output, inputs[0].getM(), inputs[0].getM());
                            break;
                        }
                        CPCostUtils.copyMissingDim(output, inputs[0].getM(), 1L);
                        break;
                    }
                    case "rsort": {
                        boolean ixRet = Boolean.parseBoolean(inputs[1].varName);
                        if (ixRet) {
                            CPCostUtils.copyMissingDim(output, inputs[0].getM(), 1L);
                            break;
                        }
                        CPCostUtils.copyMissingDim(output, inputs[0]);
                    }
                }
                break;
            }
            case Binary: {
                VarStats origin = inputs[0].isScalar() ? inputs[1] : inputs[0];
                CPCostUtils.copyMissingDim(output, origin);
                break;
            }
            case AggregateBinary: {
                boolean transposeLeft = false;
                boolean transposeRight = false;
                if (inputs.length == 4) {
                    transposeLeft = inputs[2] != null && Boolean.parseBoolean(inputs[2].varName);
                    boolean bl = transposeRight = inputs[3] != null && Boolean.parseBoolean(inputs[3].varName);
                }
                if (transposeLeft && transposeRight) {
                    CPCostUtils.copyMissingDim(output, inputs[0].getM(), inputs[1].getM());
                    break;
                }
                if (transposeLeft) {
                    CPCostUtils.copyMissingDim(output, inputs[0].getM(), inputs[1].getN());
                    break;
                }
                if (transposeRight) {
                    CPCostUtils.copyMissingDim(output, inputs[0].getN(), inputs[1].getN());
                    break;
                }
                CPCostUtils.copyMissingDim(output, inputs[0].getN(), inputs[1].getM());
                break;
            }
            case ParameterizedBuiltin: {
                if (opcode.equals(Opcodes.RMEMPTY.toString()) || opcode.equals(Opcodes.REPLACE.toString())) {
                    CPCostUtils.copyMissingDim(output, inputs[0]);
                    break;
                }
                if (!opcode.equals(Opcodes.UPPERTRI.toString()) && !opcode.equals(Opcodes.LOWERTRI.toString())) break;
                CPCostUtils.copyMissingDim(output, inputs[0].getM(), inputs[0].getM());
                break;
            }
            case Rand: {
                if (output.getCells() >= 0L) break;
                long nrows = inputs[0].varName.matches("\\d+") ? Long.parseLong(inputs[0].varName) : -1L;
                long ncols = inputs[1].varName.matches("\\d+") ? Long.parseLong(inputs[1].varName) : -1L;
                CPCostUtils.copyMissingDim(output, nrows, ncols);
                break;
            }
            case Ctable: {
                long n;
                long m = inputs[2].varName.matches("\\d+") ? Long.parseLong(inputs[2].varName) : -1L;
                long l = n = inputs[3].varName.matches("\\d+") ? Long.parseLong(inputs[3].varName) : -1L;
                if (inputs[1].isScalar()) {
                    if (m < 0L) {
                        m = inputs[0].getM();
                    }
                    if (n < 0L) {
                        n = 1L;
                    }
                    CPCostUtils.copyMissingDim(output, m, n);
                    break;
                }
                if (m < 0L) {
                    m = inputs[0].getM();
                }
                if (n < 0L) {
                    n = inputs[1].getCells();
                }
                CPCostUtils.copyMissingDim(output, m, n);
                break;
            }
            case MultiReturnBuiltin: {
                VarStats FirstStats = inputs[0];
                VarStats SecondStats = inputs[1];
                switch (opcode) {
                    case "qr": {
                        CPCostUtils.copyMissingDim(FirstStats, output.getM(), output.getM());
                        CPCostUtils.copyMissingDim(SecondStats, output.getM(), output.getN());
                        break;
                    }
                    case "lu": {
                        CPCostUtils.copyMissingDim(FirstStats, output.getN(), output.getN());
                        CPCostUtils.copyMissingDim(SecondStats, output.getN(), output.getN());
                        break;
                    }
                    case "eigen": {
                        CPCostUtils.copyMissingDim(FirstStats, output.getN(), 1L);
                        CPCostUtils.copyMissingDim(SecondStats, output.getN(), output.getN());
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Operation of type " + instType + " with opcode '" + opcode + "' has no formula for inferring dimensions");
            }
        }
        if (output.getCells() < 0L) {
            throw new RuntimeException("Operation of type " + instType + " with opcode '" + opcode + "' has incomplete formula for inferring dimensions");
        }
        if (output.getNNZ() < 0L) {
            output.characteristics.setNonZeros(output.getCells());
        }
    }

    private static void copyMissingDim(VarStats target, long originRows, long originCols) {
        if (target.getM() < 0L) {
            target.characteristics.setRows(originRows);
        }
        if (target.getN() < 0L) {
            target.characteristics.setCols(originCols);
        }
    }

    private static void copyMissingDim(VarStats target, VarStats origin) {
        if (target.getM() < 0L) {
            target.characteristics.setRows(origin.getM());
        }
        if (target.getN() < 0L) {
            target.characteristics.setCols(origin.getN());
        }
    }

    public static double getCPUTime(long nflop, IOCostUtils.IOMetrics driverMetrics, VarStats output, VarStats ... inputs) {
        double memScanTime = 0.0;
        for (VarStats input : inputs) {
            if (input == null) continue;
            memScanTime += IOCostUtils.getMemReadTime(input, driverMetrics);
        }
        double cpuComputationTime = (double)nflop / (double)driverMetrics.cpuFLOPS;
        double memWriteTime = output != null ? IOCostUtils.getMemWriteTime(output, driverMetrics) : 0.0;
        return Math.max(memScanTime, cpuComputationTime) + memWriteTime;
    }

    public static long getInstNFLOP(CPInstruction.CPType instructionType, String opcode, VarStats output, VarStats ... inputs) {
        opcode = opcode.toLowerCase();
        double costs = 0.0;
        switch (instructionType) {
            case Unary: 
            case Builtin: {
                if (output == null || inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for Unary/Builtin operations are passed initialized");
                }
                double sparsity = inputs[0].getSparsity();
                switch (opcode) {
                    case "!": 
                    case "isna": 
                    case "isnan": 
                    case "isinf": 
                    case "ceil": 
                    case "floor": {
                        costs = 1.0;
                        break;
                    }
                    case "abs": 
                    case "round": 
                    case "sign": {
                        costs = 1.0 * sparsity;
                        break;
                    }
                    case "sprop": 
                    case "sqrt": {
                        costs = 2.0 * sparsity;
                        break;
                    }
                    case "exp": {
                        costs = 18.0 * sparsity;
                        break;
                    }
                    case "sigmoid": {
                        costs = 21.0 * sparsity;
                        break;
                    }
                    case "log": {
                        costs = 32.0;
                        break;
                    }
                    case "log_nz": 
                    case "plogp": {
                        costs = 32.0 * sparsity;
                        break;
                    }
                    case "print": 
                    case "assert": {
                        costs = 1.0;
                        break;
                    }
                    case "sin": {
                        costs = 18.0 * sparsity;
                        break;
                    }
                    case "cos": {
                        costs = 22.0 * inputs[0].getSparsity();
                        break;
                    }
                    case "tan": {
                        costs = 42.0 * inputs[0].getSparsity();
                        break;
                    }
                    case "asin": 
                    case "sinh": {
                        costs = 93.0;
                        break;
                    }
                    case "acos": 
                    case "cosh": {
                        costs = 103.0;
                        break;
                    }
                    case "atan": 
                    case "tanh": {
                        costs = 40.0;
                        break;
                    }
                    case "ucumk+": 
                    case "ucummin": 
                    case "ucummax": 
                    case "ucum*": {
                        costs = 1.0 * sparsity;
                        break;
                    }
                    case "ucumk+*": {
                        costs = 2.0 * sparsity;
                        break;
                    }
                    case "stop": {
                        costs = 0.0;
                        break;
                    }
                    case "typeof": {
                        costs = 1.0;
                        break;
                    }
                    case "inverse": {
                        costs = 1.3333333333333333 * (double)output.getCellsWithSparsity() * (double)output.getCellsWithSparsity();
                        break;
                    }
                    case "cholesky": {
                        costs = 0.3333333333333333 * (double)output.getCellsWithSparsity() * (double)output.getCellsWithSparsity();
                        break;
                    }
                    case "det": 
                    case "detectschema": 
                    case "colnames": {
                        throw new RuntimeException("Specific Frame operation with opcode '" + opcode + "' is not supported yet");
                    }
                    default: {
                        throw new DMLRuntimeException("Unary operation with opcode '" + opcode + "' is not supported by SystemDS");
                    }
                }
                return (long)(costs * (double)output.getCells());
            }
            case AggregateUnary: {
                if (output == null || inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for AggregateUnary operations are passed initialized");
                }
                switch (opcode) {
                    case "nrow": 
                    case "ncol": 
                    case "length": 
                    case "exists": 
                    case "lineage": {
                        return 10L;
                    }
                    case "uak+": 
                    case "uark+": 
                    case "uack+": {
                        costs = 4.0;
                        break;
                    }
                    case "uasqk+": 
                    case "uarsqk+": 
                    case "uacsqk+": {
                        costs = 5.0;
                        break;
                    }
                    case "uamean": 
                    case "uarmean": 
                    case "uacmean": {
                        costs = 7.0;
                        break;
                    }
                    case "uavar": 
                    case "uarvar": 
                    case "uacvar": {
                        costs = 14.0;
                        break;
                    }
                    case "uamax": 
                    case "uarmax": 
                    case "uarimax": 
                    case "uacmax": 
                    case "uamin": 
                    case "uarmin": 
                    case "uarimin": 
                    case "uacmin": {
                        costs = 1.0;
                        break;
                    }
                    case "ua+": 
                    case "uar+": 
                    case "uac+": 
                    case "ua*": 
                    case "uar*": 
                    case "uac*": {
                        costs = 1.0 * output.getSparsity();
                        break;
                    }
                    case "uacd": 
                    case "uacdr": 
                    case "uacdc": 
                    case "unique": 
                    case "uniquer": 
                    case "uniquec": {
                        costs = 1.0 * output.getSparsity();
                        break;
                    }
                    case "uacdap": 
                    case "uacdapr": 
                    case "uacdapc": {
                        costs = 0.5 * output.getSparsity();
                        break;
                    }
                    case "uatrace": 
                    case "uaktrace": {
                        return inputs[0].getM();
                    }
                    default: {
                        throw new DMLRuntimeException("AggregateUnary operation with opcode '" + opcode + "' is not supported by SystemDS");
                    }
                }
                costs = opcode.startsWith("uar") ? (costs *= (double)inputs[0].getM()) : (opcode.startsWith("uac") ? (costs *= (double)inputs[0].getN()) : (costs *= (double)inputs[0].getCells()));
                return (long)(costs * (double)output.getCells());
            }
            case MMTSJ: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for MMTSJ operations are passed initialized");
                }
                costs = opcode.equals("tsmm_left") ? (double)inputs[0].getN() * (inputs[0].getSparsity() / 2.0) : (double)inputs[0].getM() * (inputs[0].getSparsity() / 2.0);
                return (long)(costs * (double)inputs[0].getCellsWithSparsity());
            }
            case Reorg: 
            case Reshape: {
                if (output == null) {
                    throw new RuntimeException("Not all required arguments for Reorg/Reshape operations are passed initialized");
                }
                if (opcode.equals(Opcodes.SORT.toString())) {
                    return (long)((double)output.getCellsWithSparsity() * (Math.log(output.getM()) / Math.log(2.0)));
                }
                return output.getCellsWithSparsity();
            }
            case MatrixIndexing: {
                if (output == null) {
                    throw new RuntimeException("Not all required arguments for Indexing operations are passed initialized");
                }
                return output.getCellsWithSparsity();
            }
            case MMChain: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for MMChain operations are passed initialized");
                }
                return 4L * inputs[0].getCellsWithSparsity() / 2L;
            }
            case QSort: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for QSort operations are passed initialized");
                }
                long m = inputs[0].getM();
                costs = opcode.equals(Opcodes.QSORT.toString()) ? (double)(m + m) : (double)m * inputs[0].getSparsity();
                return (long)(costs + (double)(m * (long)((int)(Math.log(m) / Math.log(2.0)))) + (double)m);
            }
            case CentralMoment: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for CentralMoment operations are passed initialized");
                }
                switch (opcode) {
                    case "cm_sum": {
                        throw new RuntimeException("Undefined behaviour for CentralMoment operation of type sum");
                    }
                    case "cm_min": 
                    case "cm_max": 
                    case "cm_count": {
                        costs = 2.0;
                        break;
                    }
                    case "cm_mean": {
                        costs = 9.0;
                        break;
                    }
                    case "cm_variance": 
                    case "cm_cm2": {
                        costs = 17.0;
                        break;
                    }
                    case "cm_cm3": {
                        costs = 32.0;
                        break;
                    }
                    case "cm_cm4": {
                        costs = 52.0;
                        break;
                    }
                    case "cm_invalid": {
                        throw new RuntimeException("CentralMoment operation of type INVALID is not supported");
                    }
                    default: {
                        throw new DMLRuntimeException("CentralMoment operation with type (<opcode>_<type>) '" + opcode + "' is not supported by SystemDS");
                    }
                }
                return (long)costs * inputs[0].getCellsWithSparsity();
            }
            case UaggOuterChain: 
            case Dnn: {
                throw new RuntimeException("CP operation type'" + instructionType + "' is not supported yet");
            }
            case Binary: {
                if (opcode.equals(Opcodes.PLUS.toString()) || opcode.equals(Opcodes.MINUS.toString())) {
                    if (inputs.length < 2) {
                        throw new RuntimeException("Not all required arguments for Binary operations +/- are passed initialized");
                    }
                    return inputs[0].getCellsWithSparsity() + inputs[1].getCellsWithSparsity();
                }
                if (opcode.equals(Opcodes.SOLVE.toString())) {
                    if (inputs.length < 1) {
                        throw new RuntimeException("Not all required arguments for Binary operation 'solve' are passed initialized");
                    }
                    return inputs[0].getCells() * inputs[0].getN();
                }
                if (output == null) {
                    throw new RuntimeException("Not all required arguments for Binary operations are passed initialized");
                }
                switch (opcode) {
                    case "*": 
                    case "^2": 
                    case "*2": 
                    case "max": 
                    case "min": 
                    case "-nz": 
                    case "==": 
                    case "!=": 
                    case "<": 
                    case ">": 
                    case "<=": 
                    case ">=": 
                    case "&&": 
                    case "||": 
                    case "xor": 
                    case "bitwand": 
                    case "bitwor": 
                    case "bitwxor": 
                    case "bitwshiftl": 
                    case "bitwshiftr": {
                        costs = 1.0;
                        break;
                    }
                    case "%/%": {
                        costs = 6.0;
                        break;
                    }
                    case "%%": {
                        costs = 8.0;
                        break;
                    }
                    case "/": {
                        costs = 22.0;
                        break;
                    }
                    case "log": 
                    case "log_nz": {
                        costs = 32.0;
                        break;
                    }
                    case "^": {
                        costs = 16.0;
                        break;
                    }
                    case "1-*": {
                        costs = 2.0;
                        break;
                    }
                    case "dropinvalidtype": 
                    case "dropinvalidlength": 
                    case "freplicate": 
                    case "valueswap": 
                    case "applyschema": {
                        throw new RuntimeException("Specific Frame operation with opcode '" + opcode + "' is not supported yet");
                    }
                    default: {
                        throw new DMLRuntimeException("Binary operation with opcode '" + opcode + "' is not supported by SystemDS");
                    }
                }
                return (long)(costs * (double)output.getCells());
            }
            case AggregateBinary: {
                if (output == null || inputs.length < 2) {
                    throw new RuntimeException("Not all required arguments for AggregateBinary operations are passed initialized");
                }
                if (opcode.contains("_tl")) {
                    costs = inputs[0].getCellsWithSparsity();
                }
                if (opcode.contains("_tr")) {
                    costs = inputs[1].getCellsWithSparsity();
                }
                return (long)((double)inputs[0].getN() * inputs[0].getSparsity()) * output.getCells() + (long)costs;
            }
            case Append: {
                if (inputs.length < 2) {
                    throw new RuntimeException("Not all required arguments for Append operation is passed initialized");
                }
                return inputs[0].getCellsWithSparsity() + inputs[1].getCellsWithSparsity();
            }
            case Covariance: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for Covariance operation is passed initialized");
                }
                return (long)((double)(23L * inputs[0].getM()) * inputs[0].getSparsity());
            }
            case QPick: {
                switch (opcode) {
                    case "qpick_iqm": {
                        long m = inputs[0].getM();
                        return (long)((double)(2L * m) + 1.25 * (double)m + 4.0 * (double)m);
                    }
                    case "qpick_median": 
                    case "qpick_valuepick": 
                    case "qpick_rangepick": {
                        throw new RuntimeException("QuantilePickCPInstruction of operation type different from IQM is not supported yet");
                    }
                }
                throw new DMLRuntimeException("QPick operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case Ternary: {
                if (output == null) {
                    throw new RuntimeException("Not all required arguments for Ternary operation is passed initialized");
                }
                switch (opcode) {
                    case "+*": 
                    case "-*": {
                        return 2L * output.getCells();
                    }
                    case "ifelse": {
                        return output.getCells();
                    }
                    case "_map": {
                        throw new RuntimeException("Specific Frame operation with opcode '" + opcode + "' is not supported yet");
                    }
                }
                throw new DMLRuntimeException("Ternary operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case AggregateTernary: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for AggregateTernary operation is passed initialized");
                }
                if (opcode.equals(Opcodes.TAKPM.toString()) || opcode.equals(Opcodes.TACKPM.toString())) {
                    return 6L * inputs[0].getCellsWithSparsity();
                }
                throw new DMLRuntimeException("AggregateTernary operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case Quaternary: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for Quaternary operation is passed initialized");
                }
                if (opcode.equals(Opcodes.WSLOSS.toString()) || opcode.equals(Opcodes.WDIVMM.toString()) || opcode.equals(Opcodes.WCEMM.toString())) {
                    return 4L * inputs[0].getCells();
                }
                if (opcode.equals(Opcodes.WSIGMOID.toString()) || opcode.equals(Opcodes.WUMM.toString())) {
                    return 3L * inputs[0].getCells();
                }
                throw new DMLRuntimeException("Quaternary operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case BuiltinNary: {
                if (output == null) {
                    throw new RuntimeException("Not all required arguments for BuiltinNary operation is passed initialized");
                }
                switch (opcode) {
                    case "cbind": 
                    case "rbind": {
                        return output.getCellsWithSparsity();
                    }
                    case "nmin": 
                    case "nmax": 
                    case "n+": {
                        return (long)inputs.length * output.getCellsWithSparsity();
                    }
                    case "printf": 
                    case "list": {
                        return output.getN();
                    }
                    case "eval": {
                        throw new RuntimeException("EvalNaryCPInstruction is not supported yet");
                    }
                }
                throw new DMLRuntimeException("BuiltinNary operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case Ctable: {
                if (output == null) {
                    throw new RuntimeException("Not all required arguments for Ctable operation is passed initialized");
                }
                if (opcode.startsWith(Opcodes.CTABLE.toString())) {
                    return 3L * output.getCellsWithSparsity();
                }
                throw new DMLRuntimeException("Ctable operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case PMMJ: {
                if (output == null || inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for PMMJ operation is passed initialized");
                }
                if (opcode.equals(Opcodes.PMM.toString())) {
                    return (long)((double)inputs[0].getN() * inputs[0].getSparsity()) * output.getCells();
                }
                throw new DMLRuntimeException("PMMJ operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case ParameterizedBuiltin: {
                long m = inputs[0].getM();
                switch (opcode) {
                    case "contains": 
                    case "replace": 
                    case "tostring": {
                        return inputs[0].getCells();
                    }
                    case "nvlist": 
                    case "cdf": 
                    case "invcdf": 
                    case "lowertri": 
                    case "uppertri": 
                    case "rexpand": {
                        return output.getCells();
                    }
                    case "rmempty_rows": {
                        return (long)((double)inputs[0].getM() * Math.ceil(1.0 / inputs[0].getSparsity()) / 2.0) + output.getCells();
                    }
                    case "rmempty_cols": {
                        return (long)((double)inputs[0].getN() * Math.ceil(1.0 / inputs[0].getSparsity()) / 2.0) + output.getCells();
                    }
                    case "groupedagg_count": 
                    case "groupedagg_min": 
                    case "groupedagg_max": {
                        return 2L * m + m;
                    }
                    case "groupedagg_sum": {
                        return 2L * m + 4L * m;
                    }
                    case "groupedagg_mean": {
                        return 2L * m + 8L * m;
                    }
                    case "groupedagg_cm2": {
                        return 2L * m + 16L * m;
                    }
                    case "groupedagg_cm3": {
                        return 2L * m + 31L * m;
                    }
                    case "groupedagg_cm4": {
                        return 2L * m + 51L * m;
                    }
                    case "groupedagg_variance": {
                        return 2L * m + 16L * m;
                    }
                    case "groupedagg_invalid": {
                        throw new RuntimeException("ParameterizedBuiltin operation with opcode 'groupedagg' of type INVALID is not supported");
                    }
                    case "tokenize": 
                    case "transformapply": 
                    case "transformdecode": 
                    case "transformcolmap": 
                    case "transformmeta": 
                    case "autodiff": 
                    case "paramserv": {
                        throw new RuntimeException("ParameterizedBuiltin operation with opcode '" + opcode + "' is not supported yet");
                    }
                }
                throw new DMLRuntimeException("ParameterizedBuiltin operation with opcode '" + opcode + "' is not supported by SystemDS");
            }
            case MultiReturnBuiltin: {
                if (inputs.length < 1) {
                    throw new RuntimeException("Not all required arguments for MultiReturnBuiltin operation is passed initialized");
                }
                switch (opcode) {
                    case "qr": {
                        costs = 2.0;
                        break;
                    }
                    case "lu": {
                        costs = 16.0;
                        break;
                    }
                    case "eigen": 
                    case "svd": {
                        costs = 32.0;
                        break;
                    }
                    case "fft": 
                    case "fft_linearized": {
                        throw new RuntimeException("MultiReturnBuiltin operation with opcode '" + opcode + "' is not supported yet");
                    }
                    default: {
                        throw new DMLRuntimeException(" MultiReturnBuiltin operation with opcode '" + opcode + "' is not supported by SystemDS");
                    }
                }
                int cpuFactor = InfrastructureAnalyzer.getLocalParallelism();
                return (long)((double)cpuFactor * costs * (double)inputs[0].getCells() * (double)inputs[0].getN());
            }
            case Prefetch: 
            case EvictLineageCache: 
            case Broadcast: 
            case Local: 
            case FCall: 
            case NoOp: {
                return 0L;
            }
            case Rand: 
            case Variable: 
            case StringInit: {
                throw new RuntimeException(instructionType + " instructions are not handled by this method");
            }
            case MultiReturnParameterizedBuiltin: 
            case MultiReturnComplexMatrixBuiltin: 
            case Compression: 
            case DeCompression: {
                throw new RuntimeException("CP operation type'" + instructionType + "' is not supported yet");
            }
            case TrigRemote: 
            case Partition: 
            case SpoofFused: 
            case Sql: {
                throw new RuntimeException("CP operation type'" + instructionType + "' is not planned for support");
            }
        }
        throw new DMLRuntimeException("CP operation type'" + instructionType + "' is not supported by SystemDS");
    }
}

