/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictLibMatrixMult;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ArrayIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.RangeIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.SingleIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.TwoIndex;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockFactory;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.data.SparseRowScalar;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.LibMatrixBincell;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.LeftScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class MatrixBlockDictionary
extends ADictionary {
    private static final long serialVersionUID = 2535887782150955098L;
    private final MatrixBlock _data;

    protected MatrixBlockDictionary(MatrixBlock data) {
        this._data = data;
        this._data.examSparsity();
    }

    public static MatrixBlockDictionary create(MatrixBlock mb) {
        return MatrixBlockDictionary.create(mb, true);
    }

    public static MatrixBlockDictionary create(MatrixBlock mb, boolean check) {
        if (mb == null) {
            throw new DMLCompressionException("Invalid construction of dictionary with null array");
        }
        if (mb.getNumRows() == 0 || mb.getNumColumns() == 0) {
            throw new DMLCompressionException("Invalid construction of dictionary with zero rows and/or cols array");
        }
        if (mb.isEmpty()) {
            return null;
        }
        if (check) {
            mb.examSparsity(true);
            if (mb.isInSparseFormat() && mb.getSparseBlock() instanceof SparseBlockMCSR) {
                SparseBlock csr = SparseBlockFactory.copySparseBlock(SparseBlock.Type.CSR, mb.getSparseBlock(), false);
                mb.setSparseBlock(csr);
            }
        }
        return new MatrixBlockDictionary(mb);
    }

    public static MatrixBlockDictionary createDictionary(double[] values, int nCol, boolean check) {
        if (nCol <= 1) {
            MatrixBlock mb = Util.matrixBlockFromDenseArray(values, nCol, check);
            return MatrixBlockDictionary.create(mb, check);
        }
        int nnz = MatrixBlockDictionary.checkNNz(values);
        if ((double)nnz / (double)values.length < 0.4) {
            SparseBlock sb = SparseBlockFactory.createFromArray(values, nCol, nnz);
            MatrixBlock mb = new MatrixBlock(values.length / nCol, nCol, nnz, sb);
            return MatrixBlockDictionary.create(mb, false);
        }
        return MatrixBlockDictionary.create(Util.matrixBlockFromDenseArray(values, nCol, check), false);
    }

    private static int checkNNz(double[] values) {
        int nnz = 0;
        for (int i = 0; i < values.length; ++i) {
            nnz += values[i] == 0.0 ? 0 : 1;
        }
        return nnz;
    }

    public MatrixBlock getMatrixBlock() {
        return this._data;
    }

    @Override
    public double[] getValues() {
        if (this._data.isInSparseFormat()) {
            LOG.warn((Object)"Inefficient call to getValues for a MatrixBlockDictionary because it was sparse");
            throw new DMLCompressionException("Should not call this function");
        }
        return this._data.getDenseBlockValues();
    }

    @Override
    public double getValue(int i) {
        int nCol = this._data.getNumColumns();
        int row = i / nCol;
        if (row > this._data.getNumRows()) {
            return 0.0;
        }
        int col = i % nCol;
        return this._data.get(row, col);
    }

    @Override
    public final double getValue(int r, int c, int nCol) {
        return this._data.get(r, c);
    }

    @Override
    public long getInMemorySize() {
        return 8L + this._data.estimateSizeInMemory();
    }

    public static long getInMemorySize(int numberValues, int numberColumns, double sparsity) {
        return 8L + MatrixBlock.estimateSizeInMemory((long)numberValues, (long)numberColumns, sparsity);
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MAX) {
            return fn.execute(init, this._data.max());
        }
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MIN) {
            return fn.execute(init, this._data.min());
        }
        throw new NotImplementedException();
    }

    @Override
    public double aggregateWithReference(double init, Builtin fn, double[] reference, boolean def) {
        double ret;
        block8: {
            int nRows;
            block7: {
                int nCol = reference.length;
                nRows = this._data.getNumRows();
                ret = init;
                if (def) {
                    for (int i = 0; i < nCol; ++i) {
                        ret = fn.execute(ret, reference[i]);
                    }
                }
                if (!this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRows; ++i) {
                    if (sb.isEmpty(i)) continue;
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    int[] aix = sb.indexes(i);
                    double[] avals = sb.values(i);
                    for (int k = apos; k < alen; ++k) {
                        double v = avals[k] + reference[aix[k]];
                        ret = fn.execute(ret, v);
                    }
                }
                if (def) break block8;
                int[] nnz = LibMatrixReorg.countNnzPerColumn(this._data);
                for (int i = 0; i < nnz.length; ++i) {
                    if (nnz[i] >= nRows) continue;
                    ret = fn.execute(ret, reference[i]);
                }
                break block8;
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRows; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret = fn.execute(ret, v);
                }
            }
        }
        return ret;
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    ret[i] = avals[apos];
                    for (int j = apos + 1; j < alen; ++j) {
                        ret[i] = fn.execute(ret[i], avals[j]);
                    }
                    if (sb.size(i) >= this._data.getNumColumns()) continue;
                    ret[i] = fn.execute(ret[i], 0.0);
                    continue;
                }
                ret[i] = fn.execute(ret[i], 0.0);
            }
        } else {
            if (nCol == 1) {
                return this._data.getDenseBlockValues();
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                ret[k] = values[off++];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    ret[k] = fn.execute(ret[k], values[off++]);
                }
            }
        }
        return ret;
    }

    @Override
    public double[] aggregateRowsWithDefault(Builtin fn, double[] defaultTuple) {
        int nRow = this._data.getNumRows();
        int nCol = defaultTuple.length;
        double[] ret = new double[this._data.getNumRows() + 1];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    ret[i] = avals[apos];
                    for (int j = apos + 1; j < alen; ++j) {
                        ret[i] = fn.execute(ret[i], avals[j]);
                    }
                    if (sb.size(i) >= this._data.getNumColumns()) continue;
                    ret[i] = fn.execute(ret[i], 0.0);
                    continue;
                }
                ret[i] = fn.execute(ret[i], 0.0);
            }
        } else if (nCol == 1) {
            System.arraycopy(this._data.getDenseBlockValues(), 0, ret, 0, this._data.getNumRows());
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                ret[k] = values[off++];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    ret[k] = fn.execute(ret[k], values[off++]);
                }
            }
        }
        ret[nRow] = defaultTuple[0];
        for (int i = 1; i < defaultTuple.length; ++i) {
            ret[nRow] = fn.execute(ret[nRow], defaultTuple[i]);
        }
        return ret;
    }

    @Override
    public double[] aggregateRowsWithReference(Builtin fn, double[] reference) {
        int nCol = reference.length;
        int nRows = this._data.getNumRows();
        double[] ret = new double[nRows + 1];
        ret[nRows] = reference[0];
        for (int i = 1; i < nCol; ++i) {
            ret[nRows] = fn.execute(ret[nRows], reference[i]);
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRows; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    ret[i] = ret[nRows];
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                double d = ret[i] = aix[k] == 0 ? avals[k++] + reference[0] : reference[0];
                for (j = 1; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    ret[i] = fn.execute(ret[i], v);
                }
                while (j < this._data.getNumColumns()) {
                    ret[i] = fn.execute(ret[i], reference[j]);
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRows; ++k) {
                ret[k] = values[off++] + reference[0];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret[k] = fn.execute(ret[k], v);
                }
            }
        }
        return ret;
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            MatrixBlock t = LibMatrixReorg.transpose(this._data);
            if (!t.isInSparseFormat()) {
                LOG.warn((Object)"Transpose for aggregating of columns");
                t.denseToSparse(true);
            }
            SparseBlock sbt = t.getSparseBlock();
            for (int i = 0; i < this._data.getNumColumns(); ++i) {
                int idx = colIndexes.get(i);
                if (!sbt.isEmpty(i)) {
                    int apos = sbt.pos(i);
                    int alen = sbt.size(i) + apos;
                    double[] avals = sbt.values(i);
                    for (int j = apos; j < alen; ++j) {
                        c[idx] = fn.execute(c[idx], avals[j]);
                    }
                    if (alen == this._data.getNumRows()) continue;
                    c[idx] = fn.execute(c[idx], 0.0);
                    continue;
                }
                c[idx] = fn.execute(c[idx], 0.0);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    int idx = colIndexes.get(j);
                    c[idx] = fn.execute(c[idx], values[off++]);
                }
            }
        }
    }

    @Override
    public void aggregateColsWithReference(double[] c, Builtin fn, IColIndex colIndexes, double[] reference, boolean def) {
        block8: {
            int nRow;
            int nCol;
            block7: {
                nCol = this._data.getNumColumns();
                nRow = this._data.getNumRows();
                if (def) {
                    for (int j = 0; j < colIndexes.size(); ++j) {
                        int idx = colIndexes.get(j);
                        c[idx] = fn.execute(c[idx], reference[j]);
                    }
                }
                if (!this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRow; ++i) {
                    if (sb.isEmpty(i)) continue;
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    int[] aix = sb.indexes(i);
                    for (int k = apos; k < alen; ++k) {
                        int idx = colIndexes.get(aix[k]);
                        c[idx] = fn.execute(c[idx], avals[k] + reference[aix[k]]);
                    }
                }
                if (def) break block8;
                int[] nnz = LibMatrixReorg.countNnzPerColumn(this._data);
                for (int i = 0; i < nnz.length; ++i) {
                    if (nnz[i] >= nRow) continue;
                    int idx = colIndexes.get(i);
                    c[idx] = fn.execute(c[idx], reference[i]);
                }
                break block8;
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int j = 0; j < nCol; ++j) {
                    int idx = colIndexes.get(j);
                    c[idx] = fn.execute(c[idx], values[off++] + reference[j]);
                }
            }
        }
    }

    @Override
    public IDictionary applyScalarOp(ScalarOperator op) {
        MatrixBlock res = LibMatrixBincell.bincellOpScalar(this._data, null, op, 1);
        return MatrixBlockDictionary.create(res);
    }

    @Override
    public IDictionary applyScalarOpAndAppend(ScalarOperator op, double v0, int nCol) {
        MatrixBlock ret = new MatrixBlock(this._data.getNumRows() + 1, this._data.getNumColumns(), false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        if (this._data.isInSparseFormat()) {
            int i;
            int nRow = this._data.getNumRows();
            SparseBlock sb = this._data.getSparseBlock();
            double v0r = op.executeScalar(0.0);
            for (i = 0; i < nRow; ++i) {
                int j;
                int off = i * nCol;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off + j2] = v0r;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] : 0.0;
                    retV[off + j] = op.executeScalar(v);
                }
                while (j < nCol) {
                    retV[off + j] = v0r;
                    ++j;
                }
            }
            for (i = nCol * nRow; i < retV.length; ++i) {
                retV[i] = v0;
            }
        } else {
            int i;
            double[] v = this._data.getDenseBlockValues();
            for (i = 0; i < v.length; ++i) {
                retV[i] = op.executeScalar(v[i]);
            }
            for (i = v.length; i < retV.length; ++i) {
                retV[i] = v0;
            }
        }
        ret.recomputeNonZeros();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary applyUnaryOp(UnaryOperator op) {
        MatrixBlock res = this._data.unaryOperations(op, new MatrixBlock());
        return MatrixBlockDictionary.create(res);
    }

    @Override
    public IDictionary applyUnaryOpAndAppend(UnaryOperator op, double v0, int nCol) {
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow + 1, nCol, op.sparseSafe && this._data.isInSparseFormat());
        if (op.sparseSafe && this._data.isInSparseFormat()) {
            int i;
            ret.allocateSparseRowsBlock();
            SparseBlock sb = this._data.getSparseBlock();
            SparseBlock sbr = ret.getSparseBlock();
            for (i = 0; i < nRow; ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int k = apos; k < alen; ++k) {
                    sbr.append(i, aix[k], op.fn.execute(avals[k]));
                }
            }
            for (i = 0; i < nCol; ++i) {
                sbr.append(nRow, i, v0);
            }
        } else if (this._data.isInSparseFormat()) {
            int i;
            ret.allocateDenseBlock();
            double[] retV = ret.getDenseBlockValues();
            SparseBlock sb = this._data.getSparseBlock();
            double v0r = op.fn.execute(0L);
            for (i = 0; i < nRow; ++i) {
                int j;
                int off = i * nCol;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off + j2] = v0r;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] : 0.0;
                    retV[off + j] = op.fn.execute(v);
                }
                while (j < nCol) {
                    retV[off + j] = v0r;
                    ++j;
                }
            }
            for (i = nRow * nCol; i < retV.length; ++i) {
                retV[i] = v0;
            }
        } else {
            int i;
            ret.allocateDenseBlock();
            double[] retV = ret.getDenseBlockValues();
            double[] v = this._data.getDenseBlockValues();
            for (i = 0; i < v.length; ++i) {
                retV[i] = op.fn.execute(v[i]);
            }
            for (i = nRow * nCol; i < retV.length; ++i) {
                retV[i] = v0;
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary applyScalarOpWithReference(ScalarOperator op, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.executeScalar(reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.executeScalar(v) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.executeScalar(reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.executeScalar(values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary applyUnaryOpWithReference(UnaryOperator op, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.fn.execute(v) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary binOpLeft(BinaryOperator op, double[] v, IColIndex colIndexes) {
        LOG.warn((Object)"Binary row op left is not supported for Uncompressed Matrix, Implement support for VMr in MatrixBlock Binary Cell operations");
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(v[j2], 0.0);
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double vx = aix[k] == j ? avals[k++] : 0.0;
                    retV[off++] = op.fn.execute(v[colIndexes.get(j)], vx);
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(v[colIndexes.get(j)], 0.0);
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(v[colIndexes.get(j)], values[off]);
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary binOpLeftAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        int j;
        int i;
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow + 1, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (i = 0; i < nRow; ++i) {
                int j2;
                if (sb.isEmpty(i)) {
                    for (j = 0; j < nCol; ++j) {
                        retV[off++] = op.fn.execute(v[colIndexes.get(j)], 0.0);
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j2 = 0; j2 < nCol && k < alen; ++j2) {
                    double vx = aix[k] == j2 ? avals[k++] : 0.0;
                    retV[off++] = op.fn.execute(v[colIndexes.get(j2)], vx);
                }
                while (j2 < nCol) {
                    retV[off++] = op.fn.execute(v[colIndexes.get(j2)], 0.0);
                    ++j2;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (i = 0; i < nRow; ++i) {
                for (j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(v[colIndexes.get(j)], values[off]);
                    ++off;
                }
            }
        }
        for (int j3 = 0; j3 < nCol; ++j3) {
            retV[off] = op.fn.execute(v[colIndexes.get(j3)], 0.0);
            ++off;
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpLeftWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(v[j2], reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double vx = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.fn.execute(v[j], vx) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(v[j], reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(v[j], values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpRight(BinaryOperator op, double[] v, IColIndex colIndexes) {
        if (op.fn instanceof Divide) {
            boolean all1 = true;
            for (int i = 0; i < colIndexes.size() && all1; ++i) {
                all1 = v[colIndexes.get(i)] == 1.0;
            }
            if (all1) {
                return this;
            }
        }
        MatrixBlock rowVector = Util.extractValues(v, colIndexes);
        rowVector.examSparsity();
        MatrixBlock ret = this._data.binaryOperations(op, rowVector, null);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary binOpRightAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        int j;
        int i;
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow + 1, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (i = 0; i < nRow; ++i) {
                int j2;
                if (sb.isEmpty(i)) {
                    for (j = 0; j < nCol; ++j) {
                        retV[off++] = op.fn.execute(0.0, v[colIndexes.get(j)]);
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j2 = 0; j2 < nCol && k < alen; ++j2) {
                    double vx = aix[k] == j2 ? avals[k++] : 0.0;
                    retV[off++] = op.fn.execute(vx, v[colIndexes.get(j2)]);
                }
                while (j2 < nCol) {
                    retV[off++] = op.fn.execute(0.0, v[colIndexes.get(j2)]);
                    ++j2;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (i = 0; i < nRow; ++i) {
                for (j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(values[off], v[colIndexes.get(j)]);
                    ++off;
                }
            }
        }
        for (int j3 = 0; j3 < nCol; ++j3) {
            retV[off] = op.fn.execute(0.0, v[colIndexes.get(j3)]);
            ++off;
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpRight(BinaryOperator op, double[] v) {
        MatrixBlock rowVector = new MatrixBlock(1, v.length, v);
        MatrixBlock ret = this._data.binaryOperations(op, rowVector, null);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpRightWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(reference[j2], v[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double vx = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.fn.execute(vx, v[j]) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(reference[j], v[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(values[off] + reference[j], v[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary clone() {
        MatrixBlock ret = new MatrixBlock();
        ret.copy(this._data);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary.DictType getDictType() {
        return IDictionary.DictType.MatrixBlock;
    }

    @Override
    public int getNumberOfValues(int ncol) {
        if (ncol != this._data.getNumColumns()) {
            throw new DMLCompressionException("Invalid call to get Number of values assuming wrong number of columns");
        }
        return this._data.getNumRows();
    }

    @Override
    public int getNumberOfColumns(int nrow) {
        if (nrow != this._data.getNumRows()) {
            throw new DMLCompressionException("Invalid call to get number of columns assuming wrong number of rows");
        }
        return this._data.getNumColumns();
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        int numVals = this._data.getNumRows();
        double[] ret = new double[numVals + 1];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        for (double v : defaultTuple) {
            int n = numVals;
            ret[n] = ret[n] + v;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        int nCol = reference.length;
        int numVals = this._data.getNumRows();
        double[] ret = new double[numVals + 1];
        int finalIndex = numVals;
        for (int i = 0; i < nCol; ++i) {
            int n = finalIndex;
            ret[n] = ret[n] + reference[i];
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    ret[i] = ret[finalIndex];
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    int n = i;
                    ret[n] = ret[n] + v;
                }
                while (j < this._data.getNumColumns()) {
                    int n = i;
                    ret[n] = ret[n] + reference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        double[] ret = new double[this._data.getNumRows()];
        this.sumAllRowsToDoubleSq(ret);
        return ret;
    }

    private void sumAllRowsToDoubleSq(double[] ret) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v * v;
                }
            }
        }
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithDefault(double[] defaultTuple) {
        double[] ret = new double[this._data.getNumRows() + 1];
        this.sumAllRowsToDoubleSq(ret);
        int defIdx = ret.length - 1;
        for (int j = 0; j < this._data.getNumColumns(); ++j) {
            double v = defaultTuple[j];
            int n = defIdx;
            ret[n] = ret[n] + v * v;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithReference(double[] reference) {
        int nCol = reference.length;
        int numVals = this._data.getNumRows();
        double[] ret = new double[numVals + 1];
        int finalIndex = numVals;
        for (int i = 0; i < nCol; ++i) {
            int n = finalIndex;
            ret[n] = ret[n] + reference[i] * reference[i];
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    ret[i] = ret[finalIndex];
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    int n = i;
                    ret[n] = ret[n] + v * v;
                }
                while (j < this._data.getNumColumns()) {
                    int n = i;
                    ret[n] = ret[n] + reference[j] * reference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = k;
                    ret[n] = ret[n] + v * v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] productAllRowsToDouble(int nCol) {
        double[] ret = new double[this._data.getNumRows()];
        this.productAllRowsToDouble(ret, nCol);
        return ret;
    }

    private final void productAllRowsToDouble(double[] ret, int nCol) {
        int nRow = this._data.getNumRows();
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    int[] aix = sb.indexes(i);
                    double[] avals = sb.values(i);
                    ret[i] = 1.0;
                    int pj = 0;
                    for (int j = apos; j < alen && !Double.isNaN(ret[i]); ++j) {
                        if (aix[j] - pj >= 1) {
                            ret[i] = 0.0;
                            break;
                        }
                        int n = i;
                        ret[n] = ret[n] * avals[j];
                        pj = aix[j];
                    }
                    if (Double.isNaN(ret[i]) || sb.size(i) == nCol) continue;
                    ret[i] = 0.0;
                    continue;
                }
                ret[i] = 0.0;
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int k = 0; k < nRow; ++k) {
                int off = k * nCol;
                ret[k] = 1.0;
                for (int j = 0; j < nCol && ret[k] != 0.0; ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] * v;
                }
            }
        }
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        int nRow = this._data.getNumRows();
        double[] ret = new double[nRow + 1];
        this.productAllRowsToDouble(ret, defaultTuple.length);
        ret[nRow] = defaultTuple[0];
        for (int j = 1; j < defaultTuple.length; ++j) {
            int n = nRow;
            ret[n] = ret[n] * defaultTuple[j];
        }
        return ret;
    }

    private final void productAllRowsToDoubleWithReference(double[] ret, int nCol, double[] reference) {
        int nRow = this._data.getNumRows();
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                ret[i] = 1.0;
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    int[] aix = sb.indexes(i);
                    int jj = apos;
                    for (int j = 0; j < nCol; ++j) {
                        if (jj < alen && aix[jj] == j) {
                            int n = i;
                            ret[n] = ret[n] * (avals[jj++] + reference[j]);
                            continue;
                        }
                        if (reference[j] == 0.0) {
                            ret[i] = 0.0;
                            continue;
                        }
                        int n = i;
                        ret[n] = ret[n] * reference[j];
                    }
                    continue;
                }
                for (int j = 0; j < nCol; ++j) {
                    int n = i;
                    ret[n] = ret[n] * reference[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                ret[k] = 1.0;
                for (int j = 0; j < nCol; ++j) {
                    int n = k;
                    ret[n] = ret[n] * (values[off++] + reference[j]);
                }
            }
        }
    }

    @Override
    public double[] productAllRowsToDoubleWithReference(double[] reference) {
        double[] ret = new double[this._data.getNumRows() + 1];
        this.productAllRowsToDoubleWithReference(ret, reference.length, reference);
        ret[this._data.getNumRows()] = reference[0];
        for (int j = 1; j < reference.length; ++j) {
            int n = this._data.getNumRows();
            ret[n] = ret[n] * reference[j];
        }
        return ret;
    }

    @Override
    public void colSum(double[] c, int[] counts, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            this.colSumSparse(c, counts, colIndexes);
        } else {
            this.colSumDense(c, counts, colIndexes);
        }
    }

    private void colSumSparse(double[] c, int[] counts, IColIndex colIndexes) {
        SparseBlock sb = this._data.getSparseBlock();
        for (int i = 0; i < counts.length; ++i) {
            int count = counts[i];
            if (sb.isEmpty(i) || count <= 0) continue;
            int apos = sb.pos(i);
            int alen = sb.size(i) + apos;
            int[] aix = sb.indexes(i);
            double[] avals = sb.values(i);
            for (int j = apos; j < alen; ++j) {
                int n = colIndexes.get(aix[j]);
                c[n] = c[n] + (double)count * avals[j];
            }
        }
    }

    private void colSumDense(double[] c, int[] counts, IColIndex colIndexes) {
        double[] values = this._data.getDenseBlockValues();
        int off = 0;
        for (int k = 0; k < counts.length; ++k) {
            int countK = counts[k];
            if (countK <= 0) continue;
            for (int j = 0; j < this._data.getNumColumns(); ++j) {
                double v = values[off++];
                int n = colIndexes.get(j);
                c[n] = c[n] + v * (double)countK;
            }
        }
    }

    @Override
    public void colSumSq(double[] c, int[] counts, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes.get(aix[j]);
                    c[n] = c[n] + avals[j] * avals[j] * (double)count;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes.get(j);
                    c[n] = c[n] + v * v * (double)countK;
                }
            }
        }
    }

    @Override
    public void colProduct(double[] res, int[] counts, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            int[] cnt = new int[colIndexes.size()];
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes.get(aix[j]);
                    res[n] = res[n] * Math.pow(avals[j], count);
                }
                LibMatrixAgg.countAgg(avals, cnt, aix, apos, sb.size(i));
            }
            int nVal = this.getNumberOfValues(colIndexes.size());
            for (int j = 0; j < colIndexes.size(); ++j) {
                if (cnt[j] >= nVal) continue;
                res[colIndexes.get((int)j)] = 0.0;
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int count = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes.get(j);
                    res[n] = res[n] * Math.pow(v, count);
                }
            }
        }
        MatrixBlockDictionary.correctNan(res, colIndexes);
    }

    @Override
    public void colProductWithReference(double[] res, int[] counts, IColIndex colIndexes, double[] reference) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            int[] cnt = new int[colIndexes.size()];
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes.get(aix[j]);
                    res[n] = res[n] * Math.pow(avals[j] + reference[aix[j]], count);
                }
                LibMatrixAgg.countAgg(avals, cnt, aix, apos, sb.size(i));
            }
            int nVal = this.getNumberOfValues(colIndexes.size());
            for (int j = 0; j < colIndexes.size(); ++j) {
                if (cnt[j] >= nVal || cnt[j] - nVal == 0) continue;
                int n = colIndexes.get(j);
                res[n] = res[n] * Math.pow(reference[j], cnt[j]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int count = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = colIndexes.get(j);
                    res[n] = res[n] * Math.pow(v, count);
                }
            }
        }
        MatrixBlockDictionary.correctNan(res, colIndexes);
    }

    @Override
    public void colSumSqWithReference(double[] c, int[] counts, IColIndex colIndexes, double[] reference) {
        int nCol = reference.length;
        int nRow = counts.length;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                int countK = counts[i];
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        int n = colIndexes.get(j2);
                        c[n] = c[n] + reference[j2] * reference[j2] * (double)countK;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    int n = colIndexes.get(j);
                    c[n] = c[n] + v * v * (double)countK;
                }
                while (j < this._data.getNumColumns()) {
                    int n = colIndexes.get(j);
                    c[n] = c[n] + reference[j] * reference[j] * (double)countK;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = colIndexes.get(j);
                    c[n] = c[n] + v * v * (double)countK;
                }
            }
        }
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                double rowSum = 0.0;
                if (!sb.isEmpty(i)) {
                    int count = counts[i];
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    for (int j = apos; j < alen; ++j) {
                        rowSum += (double)count * avals[j];
                    }
                }
                tmpSum += rowSum;
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                double rowSum = 0.0;
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    rowSum += v * (double)countK;
                }
                tmpSum += rowSum;
            }
        }
        return tmpSum;
    }

    @Override
    public double sumSq(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    tmpSum += (double)count * avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    tmpSum += v * v * (double)countK;
                }
            }
        }
        return tmpSum;
    }

    @Override
    public double sumSqWithReference(int[] counts, double[] reference) {
        int nCol = reference.length;
        int numVals = counts.length;
        double ret = 0.0;
        if (this._data.isInSparseFormat()) {
            double ref = 0.0;
            for (int i = 0; i < nCol; ++i) {
                ref += reference[i] * reference[i];
            }
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                int j;
                int countK = counts[i];
                if (sb.isEmpty(i)) {
                    ret += ref * (double)countK;
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    ret += v * v * (double)countK;
                }
                while (j < this._data.getNumColumns()) {
                    ret += reference[j] * reference[j] * (double)countK;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret += v * v * (double)countK;
                }
            }
        }
        return ret;
    }

    @Override
    public IDictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        MatrixBlock ret = this._data.slice(0, this._data.getNumRows() - 1, idxStart, idxEnd - 1);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._data.containsValue(pattern);
    }

    @Override
    public boolean containsValueWithReference(double pattern, double[] reference) {
        if (Double.isNaN(pattern)) {
            return super.containsValueWithReference(pattern, reference);
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                int j;
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    if (!(aix[k] == j ? reference[j] + avals[k++] == pattern : reference[j] == pattern)) continue;
                    return true;
                }
                while (j < this._data.getNumColumns()) {
                    if (reference[j] == pattern) {
                        return true;
                    }
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int nCol = reference.length;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] + reference[i % nCol] != pattern) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        long nnz = 0L;
        if (this._data.getSparseBlock() == null && this._data.getDenseBlock() == null) {
            return nnz;
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                nnz += (long)(sb.size(i) * counts[i]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int i = 0; i < counts.length; ++i) {
                int countThisTuple = 0;
                if (counts[i] == 0) continue;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v;
                    if ((v = values[off++]) == 0.0) continue;
                    ++countThisTuple;
                }
                nnz += (long)(countThisTuple * counts[i]);
            }
        }
        return nnz;
    }

    @Override
    public int[] countNNZZeroColumns(int[] counts) {
        int nRow = counts.length;
        int nCol = this._data.getNumColumns();
        int[] ret = new int[nCol];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = apos + sb.size(i);
                int[] aix = sb.indexes(i);
                for (int j = apos; j < alen; ++j) {
                    int n = aix[j];
                    ret[n] = ret[n] + counts[i];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    int off = i * nCol + j;
                    if (values[off] == 0.0) continue;
                    int n = j;
                    ret[n] = ret[n] + counts[i];
                }
            }
        }
        return ret;
    }

    @Override
    public long getNumberNonZerosWithReference(int[] counts, double[] reference, int nRows) {
        long nnz = 0L;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            long emptyRowNNZ = nnz;
            for (int i = 0; i < counts.length; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    nnz += emptyRowNNZ * (long)counts[i];
                    continue;
                }
                int countThis = 0;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    if (aix[k] == j) {
                        if (reference[j] + avals[k++] == 0.0) continue;
                        ++countThis;
                        continue;
                    }
                    if (reference[j] == 0.0) continue;
                    ++countThis;
                }
                while (j < this._data.getNumColumns()) {
                    if (reference[j] != 0.0) {
                        ++countThis;
                    }
                    ++j;
                }
                nnz += (long)(countThis * counts[i]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int i = 0; i < counts.length; ++i) {
                int countThisTuple = 0;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    if (values[off++] + reference[j] == 0.0) continue;
                    ++countThisTuple;
                }
                nnz += (long)(countThisTuple * counts[i]);
            }
        }
        return nnz;
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol) {
        if (this._data.isInSparseFormat()) {
            MatrixBlockDictionary.addToEntrySparse(this._data.getSparseBlock(), v, fr, to * nCol, nCol);
        } else {
            MatrixBlockDictionary.addToEntryDense(this._data.getDenseBlockValues(), v, fr * nCol, to * nCol, nCol);
        }
    }

    private static final void addToEntrySparse(SparseBlock sb, double[] v, int fr, int st, int nCol) {
        if (sb.isEmpty(fr)) {
            return;
        }
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        int[] aix = sb.indexes(fr);
        double[] avals = sb.values(fr);
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j];
        }
    }

    private static final void addToEntryDense(double[] thisV, double[] v, int sf, int st, int nCol) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + thisV[i];
        }
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        if (this._data.isInSparseFormat()) {
            MatrixBlockDictionary.addToEntrySparse(this._data.getSparseBlock(), v, fr, to * nCol, nCol, rep);
        } else {
            MatrixBlockDictionary.addToEntryDense(this._data.getDenseBlockValues(), v, fr * nCol, to * nCol, nCol, rep);
        }
    }

    private static final void addToEntrySparse(SparseBlock sb, double[] v, int fr, int st, int nCol, int rep) {
        if (sb.isEmpty(fr)) {
            return;
        }
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        int[] aix = sb.indexes(fr);
        double[] avals = sb.values(fr);
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j] * (double)rep;
        }
    }

    private static final void addToEntrySparseCSR(SparseBlockCSR sb, double[] v, int fr, int st, int nCol, int[] aix, double[] avals) {
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j];
        }
    }

    private static final void addToEntryDense(double[] thisV, double[] v, int sf, int st, int nCol, int rep) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + thisV[i] * (double)rep;
        }
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            if (sb instanceof SparseBlockCSR) {
                SparseBlockCSR csr = (SparseBlockCSR)sb;
                int[] aix = csr.indexes();
                double[] avals = csr.values();
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f1, t1 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f2, t2 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f3, t3 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f4, t4 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f5, t5 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f6, t6 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f7, t7 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f8, t8 * nCol, nCol, aix, avals);
            } else {
                MatrixBlockDictionary.addToEntrySparse(sb, v, f1, t1 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f2, t2 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f3, t3 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f4, t4 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f5, t5 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f6, t6 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f7, t7 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f8, t8 * nCol, nCol);
            }
        } else {
            double[] thisV = this._data.getDenseBlockValues();
            MatrixBlockDictionary.addToEntryDense(thisV, v, f1 * nCol, t1 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f2 * nCol, t2 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f3 * nCol, t3 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f4 * nCol, t4 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f5 * nCol, t5 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f6 * nCol, t6 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f7 * nCol, t7 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f8 * nCol, t8 * nCol, nCol);
        }
    }

    @Override
    public IDictionary subtractTuple(double[] tuple) {
        MatrixBlock v = new MatrixBlock(1, tuple.length, tuple);
        BinaryOperator op = new BinaryOperator(Minus.getMinusFnObject());
        MatrixBlock ret = this._data.binaryOperations(op, v, null);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary getMBDict(int nCol) {
        return this;
    }

    @Override
    public String getString(int colIndexes) {
        if (this._data.isInSparseFormat() || this._data.getNumColumns() > 1) {
            return "\n" + this._data.toString();
        }
        return Arrays.toString(this._data.getDenseBlockValues());
    }

    public String toString() {
        if (this._data.isInSparseFormat() || this._data.getNumColumns() > 1) {
            return "MatrixBlock Dictionary :\n" + this._data.toString();
        }
        return "MatrixBlock Dictionary : " + Arrays.toString(this._data.getDenseBlockValues());
    }

    @Override
    public IDictionary scaleTuples(int[] scaling, int nCol) {
        if (this._data.isInSparseFormat()) {
            MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), true);
            retBlock.allocateSparseRowsBlock(true);
            SparseBlock sbRet = retBlock.getSparseBlock();
            SparseBlock sbThis = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sbThis.isEmpty(i)) continue;
                sbRet.set(i, sbThis.get(i), true);
                int sc = scaling[i];
                int apos = sbRet.pos(i);
                int alen = sbRet.size(i) + apos;
                double[] avals = sbRet.values(i);
                for (int j = apos; j < alen; ++j) {
                    avals[j] = (double)sc * avals[j];
                }
            }
            retBlock.setNonZeros(this._data.getNonZeros());
            return MatrixBlockDictionary.create(retBlock);
        }
        double[] _values = this._data.getDenseBlockValues();
        double[] scaledValues = new double[_values.length];
        int off = 0;
        for (int tuple = 0; tuple < _values.length / nCol; ++tuple) {
            int scale = scaling[tuple];
            for (int v = 0; v < nCol; ++v) {
                scaledValues[off] = _values[off] * (double)scale;
                ++off;
            }
        }
        DenseBlockFP64 db = new DenseBlockFP64(new int[]{this._data.getNumRows(), this._data.getNumColumns()}, scaledValues);
        MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), db);
        retBlock.setNonZeros(this._data.getNonZeros());
        return MatrixBlockDictionary.create(retBlock);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.MATRIX_BLOCK_DICT.ordinal());
        this._data.write(out);
    }

    public static MatrixBlockDictionary read(DataInput in) throws IOException {
        MatrixBlock ret = new MatrixBlock();
        ret.readFields(in);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 1L + this._data.getExactSizeOnDisk();
    }

    @Override
    public MatrixBlockDictionary preaggValuesFromDense(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut) {
        int retLength = numVals * aggregateColumns.size();
        double[] ret = new double[retLength];
        if (this._data.isInSparseFormat()) {
            this.preaggValuesFromDenseDictSparse(numVals, colIndexes, aggregateColumns, b, cut, ret);
        } else {
            this.preaggValuesFromDenseDictDense(numVals, colIndexes, aggregateColumns, b, cut, ret);
        }
        MatrixBlock r = new MatrixBlock(numVals, aggregateColumns.size(), ret);
        return MatrixBlockDictionary.create(r);
    }

    public void preaggValuesFromDenseDictSparse(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut, double[] ret) {
        if (aggregateColumns instanceof ArrayIndex) {
            this.preaggValuesFromDenseDictSparseArrayIndex(numVals, colIndexes, (ArrayIndex)aggregateColumns, b, cut, ret);
        } else {
            this.preaggValuesFromDenseDictSparseGeneric(numVals, colIndexes, aggregateColumns, b, cut, ret);
        }
    }

    private void preaggValuesFromDenseDictSparseArrayIndex(int numVals, IColIndex colIndexes, ArrayIndex aggregateColumns, double[] b, int cut, double[] ret) {
        SparseBlock sb = this._data.getSparseBlock();
        for (int i = 0; i < this._data.getNumRows(); ++i) {
            if (sb.isEmpty(i)) continue;
            int off = aggregateColumns.size() * i;
            int apos = sb.pos(i);
            int alen = sb.size(i) + apos;
            double[] avals = sb.values(i);
            int[] aix = sb.indexes(i);
            for (int j = apos; j < alen; ++j) {
                int idb = colIndexes.get(aix[j]) * cut;
                double v = avals[j];
                for (int h = 0; h < aggregateColumns.size(); ++h) {
                    int n = off + h;
                    ret[n] = ret[n] + v * b[idb + aggregateColumns.get(h)];
                }
            }
        }
    }

    private void preaggValuesFromDenseDictSparseGeneric(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut, double[] ret) {
        SparseBlock sb = this._data.getSparseBlock();
        for (int i = 0; i < this._data.getNumRows(); ++i) {
            if (sb.isEmpty(i)) continue;
            int off = aggregateColumns.size() * i;
            int apos = sb.pos(i);
            int alen = sb.size(i) + apos;
            double[] avals = sb.values(i);
            int[] aix = sb.indexes(i);
            for (int j = apos; j < alen; ++j) {
                int idb = colIndexes.get(aix[j]) * cut;
                double v = avals[j];
                for (int h = 0; h < aggregateColumns.size(); ++h) {
                    int n = off + h;
                    ret[n] = ret[n] + v * b[idb + aggregateColumns.get(h)];
                }
            }
        }
    }

    public void preaggValuesFromDenseDictDense(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut, double[] ret) {
        if (aggregateColumns instanceof SingleIndex) {
            this.preaggValuesFromDenseDictDenseAggSingle(numVals, colIndexes, aggregateColumns.get(0), b, cut, ret);
        } else if (aggregateColumns instanceof TwoIndex) {
            this.preaggValuesFromDenseDictDenseAggTwo(numVals, colIndexes, (TwoIndex)aggregateColumns, b, cut, ret);
        } else if (aggregateColumns instanceof ArrayIndex) {
            this.preaggValuesFromDenseDictDenseAggArray(numVals, colIndexes, ((ArrayIndex)aggregateColumns).getArray(), b, cut, ret);
        } else if (aggregateColumns instanceof RangeIndex) {
            RangeIndex ri = (RangeIndex)aggregateColumns;
            this.preaggValuesFromDenseDictDenseAggRange(numVals, colIndexes, ri.get(0), ri.get(0) + ri.size(), b, cut, ret);
        } else {
            this.preaggValuesFromDenseDictDenseGeneric(numVals, colIndexes, aggregateColumns, b, cut, ret);
        }
    }

    private void preaggValuesFromDenseDictDenseAggSingle(int numVals, IColIndex colIndexes, int out, double[] b, int cut, double[] ret) {
        if (colIndexes instanceof TwoIndex) {
            this.preaggValuesFromDenseDictDenseAggSingleInTwo(numVals, colIndexes, out, b, cut, ret);
        } else if (colIndexes instanceof ArrayIndex) {
            this.preaggValuesFromDenseDictDenseAggSingleInArray(numVals, ((ArrayIndex)colIndexes).getArray(), out, b, cut, ret);
        } else {
            this.preaggValuesFromDenseDictDenseAggGeneric(numVals, colIndexes, out, b, cut, ret);
        }
    }

    private void preaggValuesFromDenseDictDenseAggSingleInTwo(int numVals, IColIndex colIndexes, int out, double[] b, int cut, double[] ret) {
        double[] values = this._data.getDenseBlockValues();
        int c1 = colIndexes.get(0) * cut;
        int c2 = colIndexes.get(1) * cut;
        int off = 0;
        for (int k = 0; k < numVals * 2; k += 2) {
            int n = off;
            ret[n] = ret[n] + values[k] * b[c1 + out];
            int n2 = off++;
            ret[n2] = ret[n2] + values[k + 1] * b[c2 + out];
        }
    }

    private void preaggValuesFromDenseDictDenseAggSingleInArray(int numVals, int[] colIndexes, int out, double[] b, int cut, double[] ret) {
        int cz = colIndexes.length;
        double[] values = this._data.getDenseBlockValues();
        int k = 0;
        int off = 0;
        while (k < numVals * cz) {
            for (int h = 0; h < cz; ++h) {
                int idb = colIndexes[h] * cut;
                double v = values[k + h];
                int n = off;
                ret[n] = ret[n] + v * b[idb + out];
            }
            k += cz;
            ++off;
        }
    }

    private void preaggValuesFromDenseDictDenseAggGeneric(int numVals, IColIndex colIndexes, int out, double[] b, int cut, double[] ret) {
        int cz = colIndexes.size();
        double[] values = this._data.getDenseBlockValues();
        int k = 0;
        int off = 0;
        while (k < numVals * cz) {
            for (int h = 0; h < cz; ++h) {
                int idb = colIndexes.get(h) * cut;
                double v = values[k + h];
                int n = off;
                ret[n] = ret[n] + v * b[idb + out];
            }
            k += cz;
            ++off;
        }
    }

    private void preaggValuesFromDenseDictDenseAggTwo(int numVals, IColIndex colIndexes, TwoIndex two, double[] b, int cut, double[] ret) {
        int cz = colIndexes.size();
        int az = 2;
        double[] values = this._data.getDenseBlockValues();
        int k = 0;
        int off = 0;
        while (k < numVals * cz) {
            for (int h = 0; h < cz; ++h) {
                int idb = colIndexes.get(h) * cut;
                double v = values[k + h];
                if (v == 0.0) continue;
                int n = off;
                ret[n] = ret[n] + v * b[idb + two.get(0)];
                int n2 = off + 1;
                ret[n2] = ret[n2] + v * b[idb + two.get(1)];
            }
            k += cz;
            off += 2;
        }
    }

    private void preaggValuesFromDenseDictDenseAggArray(int numVals, IColIndex colIndexes, int[] aggregateColumns, double[] b, int cut, double[] ret) {
        int cz = colIndexes.size();
        int az = aggregateColumns.length;
        double[] values = this._data.getDenseBlockValues();
        int k = 0;
        int off = 0;
        while (k < numVals * cz) {
            for (int h = 0; h < cz; ++h) {
                int idb = colIndexes.get(h) * cut;
                double v = values[k + h];
                if (v == 0.0) continue;
                for (int i = 0; i < az; ++i) {
                    int n = off + i;
                    ret[n] = ret[n] + v * b[idb + aggregateColumns[i]];
                }
            }
            k += cz;
            off += az;
        }
    }

    private void preaggValuesFromDenseDictDenseAggRange(int numVals, IColIndex colIndexes, int s, int e, double[] b, int cut, double[] ret) {
        this.preaggValuesFromDenseDictDenseAggRangeGeneric(numVals, colIndexes, s, e, b, cut, ret);
    }

    private void preaggValuesFromDenseDictDenseAggRangeGeneric(int numVals, IColIndex colIndexes, int s, int e, double[] b, int cut, double[] ret) {
        int cz = colIndexes.size();
        int nCells = numVals * cz;
        double[] values = this._data.getDenseBlockValues();
        for (int k = 0; k < cz; ++k) {
            int idb = colIndexes.get(k) * cut;
            int sOff = s + idb;
            int eOff = e + idb;
            int off = 0;
            for (int i = 0; i < nCells; i += cz) {
                double v = values[i + k];
                for (int j = sOff; j < eOff; ++j) {
                    int n = off++;
                    ret[n] = ret[n] + v * b[j];
                }
            }
        }
    }

    private void preaggValuesFromDenseDictDenseGeneric(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut, double[] ret) {
        int cz = colIndexes.size();
        int az = aggregateColumns.size();
        double[] values = this._data.getDenseBlockValues();
        int k = 0;
        int off = 0;
        while (k < numVals * cz) {
            for (int h = 0; h < cz; ++h) {
                int idb = colIndexes.get(h) * cut;
                double v = values[k + h];
                if (v == 0.0) continue;
                for (int i = 0; i < az; ++i) {
                    int n = off + i;
                    ret[n] = ret[n] + v * b[idb + aggregateColumns.get(i)];
                }
            }
            k += cz;
            off += az;
        }
    }

    @Override
    public IDictionary replace(double pattern, double replace, int nCol) {
        MatrixBlock ret = this._data.replaceOperations(new MatrixBlock(), pattern, replace);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary replaceWithReference(double pattern, double replace, double[] reference) {
        if (Util.eq(pattern, Double.NaN)) {
            return this.replaceWithReferenceNan(replace, reference);
        }
        int nRow = this._data.getNumRows();
        int nCol = this._data.getNumColumns();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = pattern == reference[j2] ? replace - reference[j2] : 0.0;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = Math.abs(v - pattern) < 1.0E-5 ? replace - reference[j] : v - reference[j];
                }
                while (j < nCol) {
                    retV[off++] = pattern == reference[j] ? replace - reference[j] : 0.0;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off];
                    retV[off++] = Math.abs(v + reference[j] - pattern) < 1.0E-5 ? replace - reference[j] : v;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    private IDictionary replaceWithReferenceNan(double replace, double[] reference) {
        Set<Integer> colsWithNan = Dictionary.getColsWithNan(replace, reference);
        int nRow = this._data.getNumRows();
        int nCol = this._data.getNumColumns();
        if (colsWithNan != null && colsWithNan.size() == nCol && replace == 0.0) {
            return null;
        }
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        if (colsWithNan == null) {
            if (this._data.isInSparseFormat()) {
                DenseBlock db = ret.getDenseBlock();
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRow; ++i) {
                    if (sb.isEmpty(i)) continue;
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    int[] aix = sb.indexes(i);
                    int j = 0;
                    int off = db.pos(i);
                    for (int k = apos; k < alen; ++k) {
                        double v = avals[k];
                        retV[off + aix[k]] = Util.eq(Double.NaN, v) ? replace - reference[j] : v;
                    }
                }
            } else {
                double[] values = this._data.getDenseBlockValues();
                Dictionary.replaceWithReferenceNanDenseWithoutNanCols(replace, reference, nRow, nCol, retV, values);
            }
        } else if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                if (sb.isEmpty(i)) continue;
                int off = i * nCol;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                int[] aix = sb.indexes(i);
                for (int k = apos; k < alen; ++k) {
                    int c = aix[k];
                    int outIdx = off + aix[k];
                    double v = avals[k];
                    retV[outIdx] = colsWithNan.contains(c) ? 0.0 : (Util.eq(v, Double.NaN) ? replace - reference[c] : v);
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            Dictionary.replaceWithReferenceNanDenseWithNanCols(replace, reference, nRow, nCol, colsWithNan, values, retV);
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public void product(double[] ret, int[] counts, int nCol) {
        if (this._data.isInSparseFormat()) {
            ret[0] = 0.0;
        } else if (this._data.getNonZeros() < (long)(this._data.getNumColumns() * this._data.getNumRows())) {
            ret[0] = 0.0;
        } else {
            MathContext cont = MathContext.DECIMAL128;
            int nRow = this._data.getNumRows();
            double[] values = this._data.getDenseBlockValues();
            BigDecimal tmp = BigDecimal.ONE;
            int off = 0;
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off++];
                    tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
                }
            }
            if (Math.abs(tmp.doubleValue()) == 0.0) {
                ret[0] = 0.0;
            } else if (!Double.isInfinite(ret[0])) {
                ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
            }
        }
    }

    @Override
    public void productWithDefault(double[] ret, int[] counts, double[] def, int defCount) {
        if (this._data.isInSparseFormat()) {
            ret[0] = 0.0;
        } else if (this._data.getNonZeros() < (long)(this._data.getNumColumns() * this._data.getNumRows())) {
            ret[0] = 0.0;
        } else {
            MathContext cont = MathContext.DECIMAL128;
            int nRow = this._data.getNumRows();
            int nCol = def.length;
            double[] values = this._data.getDenseBlockValues();
            BigDecimal tmp = BigDecimal.ONE;
            int off = 0;
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off++];
                    tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
                }
            }
            for (int x = 0; x < def.length; ++x) {
                tmp = tmp.multiply(new BigDecimal(def[x]).pow(defCount, cont), cont);
            }
            if (Math.abs(tmp.doubleValue()) == 0.0) {
                ret[0] = 0.0;
            } else if (!Double.isInfinite(ret[0])) {
                ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
            }
        }
    }

    @Override
    public void productWithReference(double[] ret, int[] counts, double[] reference, int refCount) {
        double[] values;
        Serializable tmp;
        MathContext cont = MathContext.DECIMAL128;
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        if (this._data.isInSparseFormat()) {
            tmp = new MatrixBlock();
            ((MatrixBlock)tmp).copy(this._data);
            ((MatrixBlock)tmp).sparseToDense();
            values = ((MatrixBlock)tmp).getDenseBlockValues();
        } else {
            values = this._data.getDenseBlockValues();
        }
        tmp = BigDecimal.ONE;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                double v;
                if ((v = values[off++] + reference[j]) == 0.0) {
                    ret[0] = 0.0;
                    return;
                }
                if (!Double.isFinite(v)) {
                    ret[0] = v;
                    return;
                }
                tmp = ((BigDecimal)tmp).multiply(new BigDecimal(v).pow(counts[i], cont), cont);
            }
        }
        for (int x = 0; x < reference.length; ++x) {
            tmp = ((BigDecimal)tmp).multiply(new BigDecimal(reference[x]).pow(refCount, cont), cont);
        }
        if (Math.abs(((BigDecimal)tmp).doubleValue()) == 0.0) {
            ret[0] = 0.0;
        } else if (!Double.isInfinite(ret[0])) {
            ret[0] = new BigDecimal(ret[0]).multiply((BigDecimal)tmp, cont).doubleValue();
        }
    }

    @Override
    public CM_COV_Object centralMoment(CM_COV_Object ret, ValueFunction fn, int[] counts, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i], counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, 0.0, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public CM_COV_Object centralMomentWithDefault(CM_COV_Object ret, ValueFunction fn, int[] counts, double def, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i], counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, def, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public CM_COV_Object centralMomentWithReference(CM_COV_Object ret, ValueFunction fn, int[] counts, double reference, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i] + reference, counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, reference, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public IDictionary rexpandCols(int max, boolean ignore, boolean cast, int nCol) {
        if (nCol > 1) {
            throw new DMLCompressionException("Invalid to rexpand the column groups if more than one column");
        }
        MatrixBlock ret = LibMatrixReorg.rexpand(this._data, new MatrixBlock(), max, false, cast, ignore, 1);
        if (ret.getNumColumns() == 0) {
            return null;
        }
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary rexpandColsWithReference(int max, boolean ignore, boolean cast, int reference) {
        IDictionary a = this.applyScalarOp(new LeftScalarOperator(Plus.getPlusFnObject(), reference));
        return a == null ? null : a.rexpandCols(max, ignore, cast, 1);
    }

    @Override
    public double getSparsity() {
        return this._data.getSparsity();
    }

    @Override
    public void multiplyScalar(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        if (v == 0.0) {
            return;
        }
        if (this._data.isInSparseFormat()) {
            this.multiplyScalarSparse(v, ret, off, dictIdx, cols);
        } else {
            this.multiplyScalarDense(v, ret, off, dictIdx, cols);
        }
    }

    private void multiplyScalarSparse(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        SparseBlock sb = this._data.getSparseBlock();
        if (sb.isEmpty(dictIdx)) {
            return;
        }
        int apos = sb.pos(dictIdx);
        int alen = sb.size(dictIdx) + apos;
        int[] aix = sb.indexes(dictIdx);
        double[] aval = sb.values(dictIdx);
        for (int i = apos; i < alen; ++i) {
            int n = off + cols.get(aix[i]);
            ret[n] = ret[n] + v * aval[i];
        }
    }

    private void multiplyScalarDense(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        double[] dV = this._data.getDenseBlockValues();
        int offD = dictIdx * cols.size();
        for (int i = 0; i < cols.size(); ++i) {
            int n = off + cols.get(i);
            ret[n] = ret[n] + v * dV[offD + i];
        }
    }

    @Override
    public void TSMMWithScaling(int[] counts, IColIndex rows, IColIndex cols, MatrixBlock ret) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMDictsSparseWithScaling(this._data.getSparseBlock(), rows, cols, counts, ret);
        } else {
            DictLibMatrixMult.TSMMDictsDenseWithScaling(this._data.getDenseBlockValues(), rows, cols, counts, ret);
        }
    }

    @Override
    public void MMDict(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.MMDictSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            right.MMDictDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void MMDictScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        if (this._data.isInSparseFormat()) {
            right.MMDictScalingSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result, scaling);
        } else {
            right.MMDictScalingDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result, scaling);
        }
    }

    @Override
    public void MMDictDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMDictsDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void MMDictScalingDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsScalingDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result, scaling);
        } else {
            DictLibMatrixMult.MMDictsScalingDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result, scaling);
        }
    }

    @Override
    public void MMDictSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMDictsSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void MMDictScalingSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsScalingSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result, scaling);
        } else {
            DictLibMatrixMult.MMDictsScalingSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result, scaling);
        }
    }

    @Override
    public void TSMMToUpperTriangle(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.TSMMToUpperTriangleSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            right.TSMMToUpperTriangleDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMToUpperTriangleDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMToUpperTriangleSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.TSMMToUpperTriangleSparseScaling(this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            right.TSMMToUpperTriangleDenseScaling(this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleDenseScaling(double[] left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMToUpperTriangleDenseSparseScaling(left, this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            DictLibMatrixMult.TSMMToUpperTriangleDenseDenseScaling(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleSparseScaling(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMToUpperTriangleSparseSparseScaling(left, this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            DictLibMatrixMult.TSMMToUpperTriangleSparseDenseScaling(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    public boolean equals(IDictionary o) {
        if (o == null) {
            return false;
        }
        if (o instanceof MatrixBlockDictionary) {
            return this._data.equals(((MatrixBlockDictionary)o)._data);
        }
        if (o instanceof Dictionary) {
            double[] dVals = ((Dictionary)o)._values;
            if (this._data.isEmpty()) {
                if (this._data.getNumRows() * this._data.getNumColumns() != dVals.length) {
                    return false;
                }
                for (int i = 0; i < dVals.length; ++i) {
                    if (dVals[i] == 0.0) continue;
                    return false;
                }
                return true;
            }
            if (this._data.isInSparseFormat()) {
                return this._data.getSparseBlock().equals(dVals, this._data.getNumColumns());
            }
            double[] dv = this._data.getDenseBlockValues();
            return Arrays.equals(dv, dVals);
        }
        return o.equals(this);
    }

    @Override
    public IDictionary cbind(IDictionary that, int nCol) {
        return this.cbind(that.getMBDict(nCol).getMatrixBlock());
    }

    private IDictionary cbind(MatrixBlock that) {
        return new MatrixBlockDictionary(this._data.append(that));
    }

    @Override
    public IDictionary reorder(int[] reorder) {
        MatrixBlock ret = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), this._data.getNonZeros());
        for (int r = 0; r < this._data.getNumRows(); ++r) {
            for (int c = 0; c < this._data.getNumColumns(); ++c) {
                ret.set(r, c, this._data.get(r, reorder[c]));
            }
        }
        return MatrixBlockDictionary.create(ret, false);
    }

    @Override
    public IDictionary append(double[] row) {
        if (this._data.isInSparseFormat()) {
            int nRow = this._data.getNumRows();
            int nCol = this._data.getNumColumns();
            SparseRow sr = null;
            for (int i = 0; i < row.length; ++i) {
                if (row[i] == 0.0) continue;
                sr = sr == null ? new SparseRowScalar(i, row[i]) : sr.append(i, row[i]);
            }
            MatrixBlock mb = new MatrixBlock(this._data.getNumRows() + 1, this._data.getNumColumns(), true);
            mb.allocateBlock();
            SparseBlock sb = mb.getSparseBlock();
            mb.copy(0, nRow, 0, nCol, this._data, false);
            sb.set(nRow, sr, false);
            mb.examSparsity();
            return new MatrixBlockDictionary(mb);
        }
        double[] _values = this._data.getDenseBlockValues();
        double[] retV = new double[_values.length + row.length];
        System.arraycopy(_values, 0, retV, 0, _values.length);
        System.arraycopy(row, 0, retV, _values.length, row.length);
        MatrixBlock mb = new MatrixBlock(this._data.getNumRows() + 1, this._data.getNumColumns(), retV);
        return new MatrixBlockDictionary(mb);
    }

    @Override
    protected IDictionary rightMMPreAggSparseSelectedCols(int numVals, SparseBlock b, IColIndex thisCols, IColIndex aggregateColumns) {
        int thisColsSize = thisCols.size();
        int aggColSize = aggregateColumns.size();
        double[] ret = new double[numVals * aggColSize];
        for (int h = 0; h < thisColsSize; ++h) {
            int colIdx = thisCols.get(h);
            if (b.isEmpty(colIdx)) continue;
            double[] sValues = b.values(colIdx);
            int[] sIndexes = b.indexes(colIdx);
            int sPos = b.pos(colIdx);
            int sEnd = b.size(colIdx) + sPos;
            for (int j = 0; j < numVals; ++j) {
                int offOut = j * aggColSize;
                double v = this.getValue(j, h, thisColsSize);
                this.sparseAddSelected(sPos, sEnd, aggColSize, aggregateColumns, sIndexes, sValues, ret, offOut, v);
            }
        }
        return Dictionary.create(ret);
    }

    private void sparseAddSelected(int sPos, int sEnd, int aggColSize, IColIndex aggregateColumns, int[] sIndexes, double[] sValues, double[] ret, int offOut, double v) {
        int retIdx = 0;
        for (int i = sPos; i < sEnd; ++i) {
            while (retIdx < aggColSize && aggregateColumns.get(retIdx) < sIndexes[i]) {
                ++retIdx;
            }
            if (retIdx == aggColSize) break;
            int n = offOut + retIdx;
            ret[n] = ret[n] + v * sValues[i];
        }
        retIdx = 0;
    }

    @Override
    protected IDictionary rightMMPreAggSparseAllColsRight(int numVals, SparseBlock b, IColIndex thisCols, int nColRight) {
        int thisColsSize = thisCols.size();
        double[] ret = new double[numVals * nColRight];
        for (int h = 0; h < thisColsSize; ++h) {
            int colIdx = thisCols.get(h);
            if (b.isEmpty(colIdx)) continue;
            double[] sValues = b.values(colIdx);
            int[] sIndexes = b.indexes(colIdx);
            int sPos = b.pos(colIdx);
            int sEnd = b.size(colIdx) + sPos;
            for (int i = 0; i < numVals; ++i) {
                int offOut = i * nColRight;
                double v = this.getValue(i, h, thisColsSize);
                this.SparseAdd(sPos, sEnd, ret, offOut, sIndexes, sValues, v);
            }
        }
        return Dictionary.create(ret);
    }

    private void SparseAdd(int sPos, int sEnd, double[] ret, int offOut, int[] sIdx, double[] sVals, double v) {
        if (v != 0.0) {
            for (int k = sPos; k < sEnd; ++k) {
                int n = offOut + sIdx[k];
                ret[n] = ret[n] + v * sVals[k];
            }
        }
    }
}

